/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.jdbc.CachingConnectionFactory;
import org.apache.drill.jdbc.ConnectionFactory;
import org.apache.drill.jdbc.ConnectionInfo;
import org.apache.drill.jdbc.SingleConnectionCachingFactory;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTestBase
extends ExecTest {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTestBase.class);
    @Rule
    public final TestRule watcher = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            JdbcTestBase.reset();
        }
    };
    private static CachingConnectionFactory factory;

    @BeforeClass
    public static void setUpTestCase() {
        factory = new SingleConnectionCachingFactory(new ConnectionFactory(){

            @Override
            public Connection getConnection(ConnectionInfo info) throws Exception {
                Class.forName("org.apache.drill.jdbc.Driver");
                return DriverManager.getConnection(info.getUrl(), info.getParamsAsProperties());
            }
        });
        JdbcAssert.setFactory(factory);
    }

    protected static Connection connect(String url) throws Exception {
        return JdbcTestBase.connect(url, JdbcAssert.getDefaultProperties());
    }

    protected static Connection connect(String url, Properties info) throws Exception {
        Connection conn = factory.getConnection(new ConnectionInfo(url, info));
        JdbcTestBase.changeSchemaIfSupplied(conn, info);
        return conn;
    }

    protected static void changeSchemaIfSupplied(Connection conn, Properties info) {
        String schema = info.getProperty("schema", null);
        if (!Strings.isNullOrEmpty((String)schema)) {
            JdbcTestBase.changeSchema(conn, schema);
        }
    }

    protected static void changeSchema(Connection conn, String schema) {
        String query = String.format("use %s", schema);
        try (Statement s = conn.createStatement();){
            ResultSet r = s.executeQuery(query);
        }
        catch (SQLException e) {
            throw new RuntimeException("unable to change schema", e);
        }
    }

    protected static void reset() {
        try {
            factory.closeConnections();
        }
        catch (SQLException e) {
            throw new RuntimeException("error while closing connection factory", e);
        }
    }

    @AfterClass
    public static void tearDownTestCase() throws Exception {
        factory.closeConnections();
    }

    @Ignore(value="Usually disabled; enable temporarily to check tests")
    @Test
    public void testJdbcTestConnectionResettingCompatibility() {
        Assert.fail((String)"Intentional failure--did other test methods still run?");
    }
}

