/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.InvalidCursorStateSqlException;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DrillResultSetTest
extends DrillTest {
    private static final String STATUS_SERVER_PROPERTY_NAME = "drill.exec.http.enabled";
    private static final String origStatusServerPropValue = System.getProperty("drill.exec.http.enabled", "true");

    @BeforeClass
    public static void setUpClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, "false");
    }

    @AfterClass
    public static void tearDownClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, origStatusServerPropValue);
    }

    @Test
    public void test_next_blocksFurtherAccessAfterEnd() throws SQLException {
        Connection connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 1 AS x \nFROM cp.`donuts.json` \nLIMIT 2");
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        try {
            resultSet.getInt(1);
            Assert.fail((String)"Didn't get expected SQLException.");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(InvalidCursorStateSqlException.class));
            Assert.assertThat((Object)e.toString(), (Matcher)StringContains.containsString((String)"past"));
        }
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void test_next_blocksFurtherAccessWhenNoRows() throws Exception {
        Connection connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 'Hi' AS x \nFROM cp.`donuts.json` \nWHERE false");
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        try {
            resultSet.getString(1);
            Assert.fail((String)"Didn't get expected SQLException.");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(InvalidCursorStateSqlException.class));
            Assert.assertThat((Object)e.toString(), (Matcher)StringContains.containsString((String)"past"));
            Assert.assertThat((Object)e.toString(), (Matcher)StringContains.containsString((String)"rows"));
        }
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void test_getRow_isOneBased() throws Exception {
        Connection connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("VALUES (1), (2)");
        Assert.assertThat((String)"getRow() before first next()", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
        resultSet.next();
        Assert.assertThat((String)"getRow() at first row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)1));
        resultSet.next();
        Assert.assertThat((String)"getRow() at second row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)2));
        resultSet.next();
        Assert.assertThat((String)"getRow() after last row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
        resultSet.next();
        Assert.assertThat((String)"getRow() after last row", (Object)resultSet.getRow(), (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

