/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.drill.jdbc.Driver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabaseMetaDataTest {
    private static Connection connection;
    private static DatabaseMetaData dbmd;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
        dbmd = connection.getMetaData();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testNullsAreSortedMethodsSaySortedHigh() throws SQLException {
        Assert.assertThat((String)"DatabaseMetadata.nullsAreSortedHigh()", (Object)dbmd.nullsAreSortedHigh(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"DatabaseMetadata.nullsAreSortedLow()", (Object)dbmd.nullsAreSortedLow(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((String)"DatabaseMetadata.nullsAreSortedAtEnd()", (Object)dbmd.nullsAreSortedAtEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((String)"DatabaseMetadata.nullsAreSortedAtStart()", (Object)dbmd.nullsAreSortedAtStart(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testGetIdentifierQuoteStringSaysBackquote() throws SQLException {
        Assert.assertThat((Object)dbmd.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
    }

    @Test
    public void testGetDefaultTransactionIsolationSaysNone() throws SQLException {
        Assert.assertThat((Object)dbmd.getDefaultTransactionIsolation(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testSupportsTransactionsSaysNo() throws SQLException {
        Assert.assertThat((Object)dbmd.supportsTransactions(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testSupportsTransactionIsolationLevelNoneSaysYes() throws SQLException {
        Assert.assertTrue((boolean)dbmd.supportsTransactionIsolationLevel(0));
    }

    @Test
    public void testSupportsTransactionIsolationLevelOthersSayNo() throws SQLException {
        Assert.assertFalse((boolean)dbmd.supportsTransactionIsolationLevel(1));
        Assert.assertFalse((boolean)dbmd.supportsTransactionIsolationLevel(2));
        Assert.assertFalse((boolean)dbmd.supportsTransactionIsolationLevel(4));
        Assert.assertFalse((boolean)dbmd.supportsTransactionIsolationLevel(8));
    }

    @Test
    public void testGetProceduresReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getProcedures(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetProcedureColumnsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getProcedureColumns(null, null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetTableTypesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getTableTypes(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetColumnPrivilegesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getColumnPrivileges(null, null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetTablePrivilegesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getTablePrivileges(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetBestRowIdentifierReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getBestRowIdentifier(null, null, "%", 0, true), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetVersionColumnsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getVersionColumns(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetPrimaryKeysReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getPrimaryKeys(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetImportedKeysReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getImportedKeys(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetExportedKeysReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getExportedKeys(null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetCrossReferenceReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getCrossReference(null, null, "%", null, null, "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetTypeInfoReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getTypeInfo(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetIndexInfoReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getIndexInfo(null, null, "%", false, true), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetUDTsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getUDTs(null, null, "%", null), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetSuperTypesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getSuperTypes(null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetSuperTablesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getSuperTables(null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetAttributesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getAttributes(null, null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetClientInfoPropertiesReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getClientInfoProperties(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetFunctionsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getFunctions(null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetFunctionColumnsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getFunctionColumns(null, null, "%", null), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetPseudoColumnsReturnsNonNull() throws SQLException {
        Assert.assertThat((Object)dbmd.getPseudoColumns(null, null, "%", "%"), (Matcher)CoreMatchers.notNullValue());
    }
}

