/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaDatabaseMetaData;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillDatabaseMetaData;

class DrillDatabaseMetaDataImpl
extends AvaticaDatabaseMetaData
implements DrillDatabaseMetaData {
    protected DrillDatabaseMetaDataImpl(AvaticaConnection connection) {
        super(connection);
    }

    private void checkNotClosed() throws AlreadyClosedSqlException, SQLException {
        if (this.getConnection().isClosed()) {
            throw new AlreadyClosedSqlException("DatabaseMetaData's Connection is already closed.");
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.checkNotClosed();
        return "`";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.checkNotClosed();
        return super.getCatalogs();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.checkNotClosed();
        return super.getSchemas();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.checkNotClosed();
        return super.getSchemas(catalog, schemaPattern);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.checkNotClosed();
        return super.getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet getColumns(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkNotClosed();
        return super.getColumns(catalog, schema, table, columnNamePattern);
    }
}

