/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Savepoint;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaFactory;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.Helper;
import net.hydromatic.avatica.Meta;
import net.hydromatic.avatica.UnregisteredDriver;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.TestUtilities;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.DrillConnectionConfig;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.JdbcApiSqlException;
import org.apache.drill.jdbc.impl.DrillPrepareResult;
import org.apache.drill.jdbc.impl.DrillPreparedStatementImpl;
import org.apache.drill.jdbc.impl.DrillStatementImpl;
import org.apache.drill.jdbc.impl.DrillStatementRegistry;
import org.apache.drill.jdbc.impl.DriverImpl;
import org.apache.drill.jdbc.impl.GlobalServiceSetReference;
import org.apache.drill.jdbc.impl.MetaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillConnectionImpl
extends AvaticaConnection
implements DrillConnection {
    private static final Logger logger = LoggerFactory.getLogger(DrillConnection.class);
    final DrillStatementRegistry openStatementsRegistry;
    final DrillConnectionConfig config;
    private final DrillClient client;
    private final BufferAllocator allocator;
    private Drillbit bit;
    private RemoteServiceSet serviceSet;

    protected DrillConnectionImpl(DriverImpl driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        block13: {
            super((UnregisteredDriver)driver, factory, url, info);
            this.openStatementsRegistry = new DrillStatementRegistry();
            super.setTransactionIsolation(0);
            super.setAutoCommit(true);
            this.config = new DrillConnectionConfig(info);
            try {
                if (this.config.isLocal()) {
                    try {
                        Class.forName("org.eclipse.jetty.server.Handler");
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLNonTransientConnectionException("Running Drill in embedded mode using Drill's jdbc-all JDBC driver Jar file alone is not supported.", e);
                    }
                    DrillConfig dConfig = DrillConfig.create((Properties)info);
                    this.allocator = RootAllocatorFactory.newRoot((DrillConfig)dConfig);
                    RemoteServiceSet set = GlobalServiceSetReference.SETS.get();
                    if (set == null) {
                        set = this.serviceSet = RemoteServiceSet.getLocalServiceSet();
                        try {
                            this.bit = new Drillbit(dConfig, this.serviceSet);
                            this.bit.run();
                        }
                        catch (UserException e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e.getMessage(), e);
                        }
                        catch (Exception e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e, e);
                        }
                    } else {
                        this.serviceSet = null;
                        this.bit = null;
                    }
                    DrillConnectionImpl.makeTmpSchemaLocationsUnique(this.bit.getContext().getStorage(), info);
                    this.client = new DrillClient(dConfig, set.getCoordinator());
                    this.client.connect(null, info);
                    break block13;
                }
                if (this.config.isDirect()) {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot((DrillConfig)dConfig);
                    this.client = new DrillClient(dConfig, true);
                    this.client.connect(this.config.getZookeeperConnectionString(), info);
                } else {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot((DrillConfig)dConfig);
                    this.client = new DrillClient();
                    this.client.connect(this.config.getZookeeperConnectionString(), info);
                }
            }
            catch (OutOfMemoryException e) {
                throw new SQLException("Failure creating root allocator", e);
            }
            catch (RpcException e) {
                throw new SQLException("Failure in connecting to Drill: " + (Object)((Object)e), e);
            }
        }
    }

    private void checkNotClosed() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Connection is already closed.");
        }
    }

    @Override
    public DrillConnectionConfig getConfig() {
        return this.config;
    }

    protected Meta createMeta() {
        return new MetaImpl(this);
    }

    MetaImpl meta() {
        return (MetaImpl)this.meta;
    }

    BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public DrillClient getClient() {
        return this.client;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Can't turn off auto-committing; transactions are not supported.  (Drill is not transactional.)");
        }
        assert (this.getAutoCommit()) : "getAutoCommit() = " + this.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call commit() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.commit() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call rollback() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.rollback() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new DrillRuntimeException("Unexpected exception from " + this.getClass().getSuperclass() + ".isClosed(): " + e, (Throwable)e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    private String isolationValueToString(int level) {
        switch (level) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "<Unknown transaction isolation level value " + level + ">";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new SQLFeatureNotSupportedException("Can't change transaction isolation level to Connection." + this.isolationValueToString(level) + " (from Connection." + this.isolationValueToString(this.getTransactionIsolation()) + ")." + "  (Drill is not transactional.)");
            }
            default: {
                throw new JdbcApiSqlException("Invalid transaction isolation level value " + level);
            }
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws AlreadyClosedSqlException, JdbcApiSqlException, SQLFeatureNotSupportedException {
        this.checkNotClosed();
        if (null == executor) {
            throw new InvalidParameterSqlException("Invalid (null) \"executor\" parameter to setNetworkTimeout(...)");
        }
        if (milliseconds < 0) {
            throw new InvalidParameterSqlException("Invalid (negative) \"milliseconds\" parameter to setNetworkTimeout(...) (" + milliseconds + ")");
        }
        if (0 != milliseconds) {
            throw new SQLFeatureNotSupportedException("Setting network timeout is not supported.");
        }
    }

    @Override
    public int getNetworkTimeout() throws AlreadyClosedSqlException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public DrillStatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        DrillStatementImpl statement = (DrillStatementImpl)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        try {
            DrillPrepareResult prepareResult = new DrillPrepareResult(sql);
            DrillPreparedStatementImpl statement = (DrillPreparedStatementImpl)this.factory.newPreparedStatement((AvaticaConnection)this, (AvaticaPrepareResult)prepareResult, resultSetType, resultSetConcurrency, resultSetHoldability);
            return statement;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", (Exception)e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    private static void closeOrWarn(AutoCloseable autoCloseable, String message, Logger logger) {
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            logger.warn(message, (Throwable)e);
        }
    }

    void cleanup() {
        this.openStatementsRegistry.close();
        DrillConnectionImpl.closeOrWarn((AutoCloseable)this.client, "Exception while closing client.", logger);
        DrillConnectionImpl.closeOrWarn((AutoCloseable)this.allocator, "Exception while closing allocator.", logger);
        if (this.bit != null) {
            this.bit.close();
        }
        DrillConnectionImpl.closeOrWarn((AutoCloseable)this.serviceSet, "Exception while closing service set.", logger);
    }

    private static void makeTmpSchemaLocationsUnique(StoragePluginRegistry pluginRegistry, Properties props) {
        try {
            if (props != null && "true".equalsIgnoreCase(props.getProperty("drillJDBCUnitTests"))) {
                String tmpDirPath = TestUtilities.createTempDir();
                TestUtilities.updateDfsTestTmpSchemaLocation((StoragePluginRegistry)pluginRegistry, (String)tmpDirPath);
                TestUtilities.makeDfsTmpSchemaImmutable((StoragePluginRegistry)pluginRegistry);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to update tmp schema locations. This step is purely for testing purpose. Shouldn't be seen in production code.");
        }
    }
}

