/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.hydromatic.avatica.Cursor;
import org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.jdbc.InvalidCursorStateSqlException;
import org.apache.drill.jdbc.impl.DrillCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvaticaDrillSqlAccessor
implements Cursor.Accessor {
    private static final Logger logger = LoggerFactory.getLogger(AvaticaDrillSqlAccessor.class);
    private static final byte PRIMITIVE_NUM_NULL_VALUE = 0;
    private static final boolean BOOLEAN_NULL_VALUE = false;
    private SqlAccessor underlyingAccessor;
    private DrillCursor cursor;

    AvaticaDrillSqlAccessor(SqlAccessor drillSqlAccessor, DrillCursor cursor) {
        this.underlyingAccessor = drillSqlAccessor;
        this.cursor = cursor;
    }

    private int getCurrentRecordNumber() throws SQLException {
        if (this.cursor.getResultSet().isAfterLast()) {
            throw new InvalidCursorStateSqlException("Result set cursor is already positioned past all rows.");
        }
        if (this.cursor.getResultSet().isBeforeFirst()) {
            throw new InvalidCursorStateSqlException("Result set cursor is positioned before all rows.  Call next() first.");
        }
        return this.cursor.getCurrentRecordNumber();
    }

    public Class<?> getObjectClass() {
        return this.underlyingAccessor.getObjectClass();
    }

    public boolean wasNull() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber());
    }

    public String getString() throws SQLException {
        return this.underlyingAccessor.getString(this.getCurrentRecordNumber());
    }

    public boolean getBoolean() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? false : this.underlyingAccessor.getBoolean(this.getCurrentRecordNumber());
    }

    public byte getByte() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? (byte)0 : this.underlyingAccessor.getByte(this.getCurrentRecordNumber());
    }

    public short getShort() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? (short)0 : this.underlyingAccessor.getShort(this.getCurrentRecordNumber());
    }

    public int getInt() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? 0 : this.underlyingAccessor.getInt(this.getCurrentRecordNumber());
    }

    public long getLong() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? 0L : this.underlyingAccessor.getLong(this.getCurrentRecordNumber());
    }

    public float getFloat() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? 0.0f : this.underlyingAccessor.getFloat(this.getCurrentRecordNumber());
    }

    public double getDouble() throws SQLException {
        return this.underlyingAccessor.isNull(this.getCurrentRecordNumber()) ? 0.0 : this.underlyingAccessor.getDouble(this.getCurrentRecordNumber());
    }

    public BigDecimal getBigDecimal() throws SQLException {
        return this.underlyingAccessor.getBigDecimal(this.getCurrentRecordNumber());
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public byte[] getBytes() throws SQLException {
        return this.underlyingAccessor.getBytes(this.getCurrentRecordNumber());
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.underlyingAccessor.getStream(this.getCurrentRecordNumber());
    }

    public InputStream getUnicodeStream() throws SQLException {
        return this.underlyingAccessor.getStream(this.getCurrentRecordNumber());
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.underlyingAccessor.getStream(this.getCurrentRecordNumber());
    }

    public Object getObject() throws SQLException {
        return this.underlyingAccessor.getObject(this.getCurrentRecordNumber());
    }

    public Reader getCharacterStream() throws SQLException {
        return this.underlyingAccessor.getReader(this.getCurrentRecordNumber());
    }

    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Ref getRef() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Blob getBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Clob getClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Array getArray() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Date getDate(Calendar calendar) throws SQLException {
        return this.underlyingAccessor.getDate(this.getCurrentRecordNumber());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        return this.underlyingAccessor.getTime(this.getCurrentRecordNumber());
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        return this.underlyingAccessor.getTimestamp(this.getCurrentRecordNumber());
    }

    public URL getURL() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public NClob getNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public SQLXML getSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getNString() throws SQLException {
        return this.underlyingAccessor.getString(this.getCurrentRecordNumber());
    }

    public Reader getNCharacterStream() throws SQLException {
        return this.underlyingAccessor.getReader(this.getCurrentRecordNumber());
    }

    public <T> T getObject(Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

