/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestExecutionExceptionsToClient
extends JdbcTestBase {
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws Exception {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testExecuteQueryThrowsRight1() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.executeQuery("SELECT one case of syntax error");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }

    @Test
    public void testExecuteThrowsRight1() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.execute("SELECT one case of syntax error");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }

    @Test
    public void testExecuteUpdateThrowsRight1() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("SELECT one case of syntax error");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }

    @Test
    public void testExecuteQueryThrowsRight2() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.executeQuery("BAD QUERY 1");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }

    @Test
    public void testExecuteThrowsRight2() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.execute("worse query 2");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }

    @Test
    public void testExecuteUpdateThrowsRight2() throws Exception {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("naughty, naughty query 3");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Null getCause(); missing expected wrapped exception", (Object)e.getCause(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"Unexpectedly wrapped another SQLException", (Object)e.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SQLException.class)));
            Assert.assertThat((String)"getCause() not UserRemoteException as expected", (Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UserRemoteException.class));
            Assert.assertThat((String)"No expected current \"SYSTEM ERROR\"/eventual \"PARSE ERROR\"", (Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.startsWith((String)"SYSTEM ERROR"), (Matcher)CoreMatchers.startsWith((String)"PARSE ERROR")));
        }
    }
}

