/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Stopwatch;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.junit.Rule;
import org.junit.rules.TestRule;

public class JdbcTestQueryBase
extends JdbcTestBase {
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)40000);
    protected static final String WORKING_PATH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testQuery(String sql) throws Exception {
        boolean success = false;
        try (Connection conn = JdbcTestQueryBase.connect("jdbc:drill:zk=local");){
            for (int x = 0; x < 1; ++x) {
                Stopwatch watch = new Stopwatch().start();
                Statement s = conn.createStatement();
                ResultSet r = s.executeQuery(sql);
                System.out.println(String.format("QueryId: %s", r.unwrap(DrillResultSet.class).getQueryId()));
                boolean first = true;
                while (r.next()) {
                    int i;
                    ResultSetMetaData md = r.getMetaData();
                    if (first) {
                        for (i = 1; i <= md.getColumnCount(); ++i) {
                            System.out.print(md.getColumnName(i));
                            System.out.print('\t');
                        }
                        System.out.println();
                        first = false;
                    }
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        System.out.print(r.getObject(i));
                        System.out.print('\t');
                    }
                    System.out.println();
                }
                System.out.println(String.format("Query completed in %d millis.", watch.elapsed(TimeUnit.MILLISECONDS)));
            }
            System.out.println("\n\n\n");
            success = true;
        }
        finally {
            if (!success) {
                Thread.sleep(2000L);
            }
        }
    }

    static {
        Driver.load();
        WORKING_PATH = Paths.get("", new String[0]).toAbsolutePath().toString();
    }
}

