/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.util.Hook;
import org.apache.drill.exec.planner.PhysicalPlanReaderTestFactory;
import org.apache.drill.jdbc.ConnectionFactory;
import org.apache.drill.jdbc.ConnectionInfo;
import org.junit.Assert;

public class JdbcAssert {
    private static ConnectionFactory factory = null;

    public static void setFactory(ConnectionFactory factory) {
        JdbcAssert.factory = factory;
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("drillJDBCUnitTests", "true");
        properties.setProperty("drill.exec.http.enabled", "false");
        return properties;
    }

    public static ModelAndSchema withModel(String model, String schema) {
        Properties info = JdbcAssert.getDefaultProperties();
        info.setProperty("schema", schema);
        info.setProperty("model", "inline:" + model);
        return new ModelAndSchema(info, factory);
    }

    public static ModelAndSchema withFull(String schema) {
        Properties info = JdbcAssert.getDefaultProperties();
        info.setProperty("schema", schema);
        return new ModelAndSchema(info, factory);
    }

    public static ModelAndSchema withNoDefaultSchema() {
        return new ModelAndSchema(JdbcAssert.getDefaultProperties(), factory);
    }

    static String toString(ResultSet resultSet, int expectedRecordCount) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int n = metaData.getColumnCount();
            String sep = "";
            for (int i = 1; i <= n; ++i) {
                buf.append(sep).append(metaData.getColumnLabel(i)).append("=").append(resultSet.getObject(i));
                sep = "; ";
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static String toString(ResultSet resultSet) throws SQLException {
        StringBuilder buf = new StringBuilder();
        List<Ord<String>> columns = JdbcAssert.columnLabels(resultSet);
        while (resultSet.next()) {
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static Set<String> toStringSet(ResultSet resultSet) throws SQLException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List<Ord<String>> columns = JdbcAssert.columnLabels(resultSet);
        while (resultSet.next()) {
            StringBuilder buf = new StringBuilder();
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            builder.add((Object)buf.toString());
            buf.setLength(0);
        }
        return builder.build();
    }

    static List<String> toStrings(ResultSet resultSet) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        List<Ord<String>> columns = JdbcAssert.columnLabels(resultSet);
        while (resultSet.next()) {
            buf.setLength(0);
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            list.add(buf.toString());
        }
        return list;
    }

    private static List<Ord<String>> columnLabels(ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        ArrayList<Ord<String>> columns = new ArrayList<Ord<String>>();
        for (int i = 1; i <= n; ++i) {
            columns.add((Ord<String>)Ord.of((int)i, (Object)resultSet.getMetaData().getColumnLabel(i)));
        }
        return columns;
    }

    private static interface ConnectionFactoryAdapter {
        public Connection createConnection() throws Exception;
    }

    public static class TestDataConnection {
        private final ConnectionFactoryAdapter adapter;
        private final String sql;

        TestDataConnection(ConnectionFactoryAdapter adapter, String sql) {
            this.adapter = adapter;
            this.sql = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestDataConnection returns(String expected) throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.adapter.createConnection();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.sql);
                expected = expected.trim();
                String result = JdbcAssert.toString(resultSet).trim();
                resultSet.close();
                if (!expected.equals(result)) {
                    Assert.fail((String)String.format("Generated string:\n%s\ndoes not match:\n%s", result, expected));
                }
                TestDataConnection testDataConnection = this;
                return testDataConnection;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestDataConnection returnsSet(Set<String> expected) throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.adapter.createConnection();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.sql);
                Set<String> result = JdbcAssert.toStringSet(resultSet);
                resultSet.close();
                if (!expected.equals(result)) {
                    Assert.fail((String)String.format("Generated set:\n%s\ndoes not match:\n%s", result, expected));
                }
                TestDataConnection testDataConnection = this;
                return testDataConnection;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestDataConnection returnsUnordered(String ... expecteds) throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.adapter.createConnection();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.sql);
                Assert.assertEquals(this.unsortedList(Arrays.asList(expecteds)), this.unsortedList(JdbcAssert.toStrings(resultSet)));
                resultSet.close();
                TestDataConnection testDataConnection = this;
                return testDataConnection;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestDataConnection displayResults(int recordCount) throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.adapter.createConnection();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.sql);
                System.out.println(JdbcAssert.toString(resultSet, recordCount));
                resultSet.close();
                TestDataConnection testDataConnection = this;
                return testDataConnection;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }

        private SortedSet<String> unsortedList(List<String> strings) {
            TreeSet<String> set = new TreeSet<String>();
            for (String string : strings) {
                set.add(string + "\n");
            }
            return set;
        }

        public LogicalPlan logicalPlan() {
            final String[] plan0 = new String[]{null};
            Connection connection = null;
            Statement statement = null;
            Hook.Closeable x = Hook.LOGICAL_PLAN.add((Function)new Function<String, Void>(){

                public Void apply(String o) {
                    plan0[0] = o;
                    return null;
                }
            });
            try {
                connection = this.adapter.createConnection();
                statement = connection.prepareStatement(this.sql);
                statement.close();
                String plan = plan0[0].trim();
                LogicalPlan logicalPlan = LogicalPlan.parse((LogicalPlanPersistence)PhysicalPlanReaderTestFactory.defaultLogicalPlanPersistence((DrillConfig)DrillConfig.create()), (String)plan);
                return logicalPlan;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                x.close();
            }
        }

        public <T extends LogicalOperator> T planContains(final Class<T> operatorClazz) {
            return (T)((LogicalOperator)Iterables.find((Iterable)this.logicalPlan().getSortedOperators(), (Predicate)new Predicate<LogicalOperator>(){

                public boolean apply(LogicalOperator input) {
                    return input.getClass().equals(operatorClazz);
                }
            }));
        }
    }

    public static class ModelAndSchema {
        private final Properties info;
        private final ConnectionFactoryAdapter adapter;

        public ModelAndSchema(Properties info, final ConnectionFactory factory) {
            this.info = info;
            this.adapter = new ConnectionFactoryAdapter(){

                @Override
                public Connection createConnection() throws Exception {
                    return factory.getConnection(new ConnectionInfo("jdbc:drill:zk=local", ModelAndSchema.this.info));
                }
            };
        }

        public TestDataConnection sql(String sql) {
            return new TestDataConnection(this.adapter, sql);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T withConnection(Function<Connection, T> function) throws Exception {
            try (Connection connection = null;){
                connection = this.adapter.createConnection();
                Object object = function.apply((Object)connection);
                return (T)object;
            }
        }
    }
}

