/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.drill.jdbc.JdbcTestBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Drill2461IntervalsBreakInfoSchemaBugTest
extends JdbcTestBase {
    private static final String VIEW_NAME = Drill2461IntervalsBreakInfoSchemaBugTest.class.getSimpleName() + "_View";
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws Exception {
        connection = Drill2461IntervalsBreakInfoSchemaBugTest.connect("jdbc:drill:zk=local");
    }

    @AfterClass
    public static void tearDownConnection() throws Exception {
        connection.close();
    }

    @Test
    public void testIntervalInViewDoesntCrashInfoSchema() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet util = stmt.executeQuery("USE dfs_test.tmp");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error setting schema to dfs_test.tmp: " + util.getString(2)), (boolean)util.getBoolean(1));
        util = stmt.executeQuery("CREATE OR REPLACE VIEW " + VIEW_NAME + " AS " + "\n  SELECT CAST( NULL AS INTERVAL HOUR(4) TO MINUTE ) AS optINTERVAL_HM " + "\n  FROM INFORMATION_SCHEMA.CATALOGS " + "\n  LIMIT 1 ");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error creating temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        util = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS");
        Assert.assertTrue((boolean)util.next());
        util = connection.createStatement().executeQuery("DROP VIEW " + VIEW_NAME);
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error dropping temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
    }
}

