/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatementTest
extends JdbcTestBase {
    private static Connection connection;
    private static Statement statement;

    @BeforeClass
    public static void setUpStatement() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
        statement = connection.createStatement();
    }

    @AfterClass
    public static void tearDownStatement() throws SQLException {
        connection.close();
    }

    @Test
    public void testGetQueryTimeoutSaysNoTimeout() throws SQLException {
        Assert.assertThat((Object)statement.getQueryTimeout(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testSetQueryTimeoutAcceptsNotimeoutRequest() throws SQLException {
        statement.setQueryTimeout(0);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetQueryTimeoutRejectsTimeoutRequest() throws SQLException {
        try {
            statement.setQueryTimeout(1000);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"Timeout"), (Matcher)CoreMatchers.containsString((String)"timeout")));
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetQueryTimeoutRejectsTimeoutRequest2() throws SQLException {
        statement.setQueryTimeout(0x3FFFFFFF);
    }

    @Test(expected=InvalidParameterSqlException.class)
    public void testSetQueryTimeoutRejectsBadTimeoutValue() throws SQLException {
        try {
            statement.setQueryTimeout(-2);
        }
        catch (InvalidParameterSqlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"milliseconds"), (Matcher)CoreMatchers.containsString((String)"timeout"), (Matcher)CoreMatchers.containsString((String)"Timeout")));
            throw e;
        }
    }
}

