/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PreparedStatementTest
extends JdbcTestBase {
    private static final Matcher<String> PARAMETERS_NOT_SUPPORTED_MSG_MATCHER = CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"arameter"), (Matcher)CoreMatchers.containsString((String)"not"), (Matcher)CoreMatchers.containsString((String)"support"));
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        Driver.load();
        connection = DriverManager.getConnection("jdbc:drill:zk=local");
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testExecuteQueryBasicCaseWorks() throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("VALUES 11");
        ResultSet rs = stmt.executeQuery();
        Assert.assertThat((String)"Unexpected column count", (Object)rs.getMetaData().getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertTrue((String)"No expected first row", (boolean)rs.next());
        Assert.assertThat((Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)11));
        Assert.assertFalse((String)"Unexpected second row", (boolean)rs.next());
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingSaysUnsupported() throws SQLException {
        PreparedStatement prepStmt = connection.prepareStatement("VALUES ?, ?");
        try {
            prepStmt.setInt(0, 123456789);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWithImpossibleIndexSaysUnsupported() throws SQLException {
        PreparedStatement prepStmt = connection.prepareStatement("VALUES ?, ?");
        try {
            prepStmt.setString(-1, "some value");
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWithInconsistentIndexSaysUnsupported() throws SQLException {
        PreparedStatement prepStmt = connection.prepareStatement("VALUES ?, ?");
        try {
            prepStmt.setBytes(4, null);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWhenNoParametersIndexSaysUnsupported() throws SQLException {
        PreparedStatement prepStmt = connection.prepareStatement("VALUES 1");
        try {
            prepStmt.setBytes(4, null);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWhenUnsupportedTypeSaysUnsupported() throws SQLException {
        PreparedStatement prepStmt = connection.prepareStatement("VALUES 1");
        try {
            prepStmt.setClob(2, (Clob)null);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
            throw e;
        }
    }
}

