/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class DriverTest
extends DrillTest {
    private static final String STATUS_SERVER_PROPERTY_NAME = "drill.exec.http.enabled";
    private static final String origJettyPropValue = System.getProperty("drill.exec.http.enabled", "true");
    private Driver uut = new Driver();

    @BeforeClass
    public static void setUpClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, "false");
    }

    @AfterClass
    public static void tearDownClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, origJettyPropValue);
    }

    @Test
    public void test_connect_declinesEmptyUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("", null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_connect_declinesNonUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("whatever", null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_connect_declinesNonJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("file:///something", null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_connect_declinesNonDrillJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("jdbc:somedb:whatever", null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_connect_declinesNotQuiteDrillUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("jdbc:drill", null), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="Just hangs, trying to connect to non-existent local zookeeper.")
    @Test
    public void test_connect_acceptsMinimalDrillJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("jdbc:drill:", null), (Matcher)CoreMatchers.nullValue());
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Just hangs, trying to connect to non-existent local zookeeper.")
    @Test
    public void test_connect_DECIDEWHICHBogusDrillJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.connect("jdbc:drill:x=y;z;;a=b=c=d;what=ever", null), (Matcher)CoreMatchers.nullValue());
        Assert.fail((String)"Not implemented yet");
    }

    @Test
    public void test_connect_acceptsLocalZkDrillJdbcUrl() throws SQLException {
        Connection connection = this.uut.connect("jdbc:drill:zk=local", null);
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        connection.close();
    }

    @Test
    public void test_connect_acceptsLocalViaProperties() throws SQLException {
        Properties props = new Properties();
        props.put("zk", "local");
        Connection connection = this.uut.connect("jdbc:drill:", props);
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        connection.close();
    }

    @Test
    public void test_acceptsURL_acceptsDrillUrlMinimal() throws SQLException {
        Assert.assertThat((Object)this.uut.acceptsURL("jdbc:drill:"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_acceptsURL_acceptsDrillPlusJunk() throws SQLException {
        Assert.assertThat((Object)this.uut.acceptsURL("jdbc:drill:should it check this?"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_acceptsURL_rejectsNonDrillJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.acceptsURL("jdbc:notdrill:whatever"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_acceptsURL_rejectsNonDrillJdbc2() throws SQLException {
        Assert.assertThat((Object)this.uut.acceptsURL("jdbc:optiq:"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_acceptsURL_rejectsNonJdbcUrl() throws SQLException {
        Assert.assertThat((Object)this.uut.acceptsURL("drill:"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getPropertyInfo() throws SQLException {
        Assert.fail((String)"Not implemented yet");
    }

    @Test
    public void test_getMajorVersion() {
        Assert.assertThat((Object)this.uut.getMajorVersion(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void test_getMinorVersion() {
        Assert.assertThat((Object)this.uut.getMinorVersion(), (Matcher)Is.is((Object)0));
    }

    @Ignore(value="Seemingly: Bug: Returns true, but hasn't passed compliance tests.")
    @Test
    public void test_jdbcCompliant() {
        Assert.assertThat((Object)this.uut.jdbcCompliant(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getParentLogger() {
        Assert.fail((String)"Not implemented yet");
    }

    @Test
    public void test_Driver_registersWithManager() throws SQLException {
        Assert.assertThat((Object)DriverManager.getDriver("jdbc:drill:whatever"), (Matcher)CoreMatchers.instanceOf(Driver.class));
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_load() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getConnectStringPrefix() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getFactoryClassNameJdbcVersion() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_createDriverVersion() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_createHandler() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_unregisteredDriver() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_createFactory() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_createHandler1() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getFactoryClassNameJdbcVersion1() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_createDriverVersion1() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getConnectionProperties() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_instantiateFactory() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getConnectStringPrefix1() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_getDriverVersion() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_register() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_hashCode() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_equals() {
        Assert.fail((String)"Not implemented yet");
    }

    @Ignore(value="Deferred pending need.")
    @Test
    public void test_toString() {
        Assert.fail((String)"Not implemented yet");
    }
}

