/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import net.hydromatic.avatica.ColumnMetaData;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.jdbc.impl.DrillColumnMetaDataList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DrillColumnMetaDataListTest {
    private DrillColumnMetaDataList emptyList;
    private DrillColumnMetaDataList oneElementList;
    private DrillColumnMetaDataList twoElementList;
    private ColumnMetaData exampleIntColumn = new ColumnMetaData(0, false, false, false, false, 0, true, 10, "intLabel", "intColName", "schemaName", 0, 1, ",myTable", "myCategory", (ColumnMetaData.AvaticaType)new ColumnMetaData.ScalarType(1, "myIntType", ColumnMetaData.Rep.INTEGER), true, false, false, Integer.class.getName());
    private ColumnMetaData exampleStringColumn = new ColumnMetaData(0, false, false, false, false, 0, true, 10, "stringLabel", "stringColName", "schemaName", 0, 1, ",myTable", "myCategory", (ColumnMetaData.AvaticaType)new ColumnMetaData.ScalarType(1, "myStringType", ColumnMetaData.Rep.STRING), false, true, true, String.class.getName());

    @Before
    public void setUp() throws Exception {
        this.emptyList = new DrillColumnMetaDataList();
        final MaterializedField exampleIntField = (MaterializedField)Mockito.mock(MaterializedField.class);
        TypeProtos.MajorType exampleIntType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.INT).build();
        Mockito.when((Object)exampleIntField.getPath()).thenReturn((Object)SchemaPath.getSimplePath((String)"/path/to/testInt"));
        Mockito.when((Object)exampleIntField.getType()).thenReturn((Object)exampleIntType);
        Mockito.when((Object)exampleIntField.getDataMode()).thenReturn((Object)TypeProtos.DataMode.OPTIONAL);
        final MaterializedField exampleStringField = (MaterializedField)Mockito.mock(MaterializedField.class);
        TypeProtos.MajorType exampleStringType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARCHAR).build();
        Mockito.when((Object)exampleStringField.getPath()).thenReturn((Object)SchemaPath.getSimplePath((String)"/path/to/testString"));
        Mockito.when((Object)exampleStringField.getType()).thenReturn((Object)exampleStringType);
        Mockito.when((Object)exampleStringField.getDataMode()).thenReturn((Object)TypeProtos.DataMode.REQUIRED);
        this.oneElementList = new DrillColumnMetaDataList();
        BatchSchema oneElementSchema = (BatchSchema)Mockito.mock(BatchSchema.class);
        Mockito.when((Object)oneElementSchema.getFieldCount()).thenReturn((Object)1);
        ((BatchSchema)Mockito.doAnswer((Answer)new Answer<MaterializedField>(){

            public MaterializedField answer(InvocationOnMock invocationOnMock) throws Throwable {
                Integer index = (Integer)invocationOnMock.getArguments()[0];
                if (index == 0) {
                    return exampleIntField;
                }
                return null;
            }
        }).when((Object)oneElementSchema)).getColumn(Mockito.anyInt());
        ArrayList<Class<Integer>> oneClassList = new ArrayList<Class<Integer>>();
        oneClassList.add(Integer.class);
        this.oneElementList.updateColumnMetaData("testCatalog", "testSchema", "testTable", oneElementSchema, oneClassList);
        this.twoElementList = new DrillColumnMetaDataList();
        BatchSchema twoElementSchema = (BatchSchema)Mockito.mock(BatchSchema.class);
        Mockito.when((Object)twoElementSchema.getFieldCount()).thenReturn((Object)2);
        ((BatchSchema)Mockito.doAnswer((Answer)new Answer<MaterializedField>(){

            public MaterializedField answer(InvocationOnMock invocationOnMock) throws Throwable {
                Integer index = (Integer)invocationOnMock.getArguments()[0];
                if (index == 0) {
                    return exampleIntField;
                }
                if (index == 1) {
                    return exampleStringField;
                }
                return null;
            }
        }).when((Object)twoElementSchema)).getColumn(Mockito.anyInt());
        ArrayList<Class> twoClassList = new ArrayList<Class>();
        twoClassList.add(Integer.class);
        twoClassList.add(String.class);
        this.twoElementList.updateColumnMetaData("testCatalog", "testSchema", "testTable", twoElementSchema, twoClassList);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSize() throws Exception {
        Assert.assertEquals((String)"Default constructor should give empty list", (long)0L, (long)this.emptyList.size());
        Assert.assertEquals((long)1L, (long)this.oneElementList.size());
        Assert.assertEquals((long)2L, (long)this.twoElementList.size());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetFromEmptyList() throws Exception {
        this.emptyList.get(0);
    }

    @Test
    public void testGetFromNonEmptyList() throws Exception {
        Assert.assertEquals((Object)this.oneElementList.get((int)0).columnName, (Object)"/path/to/testInt");
        Assert.assertEquals((Object)this.twoElementList.get((int)0).columnName, (Object)"/path/to/testInt");
        Assert.assertEquals((Object)this.twoElementList.get((int)1).columnName, (Object)"/path/to/testString");
    }

    @Test
    public void testUpdateColumnMetaData() throws Exception {
    }

    @Test
    public void testIsEmpty() throws Exception {
        Assert.assertTrue((String)"Default constructor should give empty list", (boolean)this.emptyList.isEmpty());
        Assert.assertFalse((String)"One-element List should not be empty", (boolean)this.oneElementList.isEmpty());
        Assert.assertFalse((String)"Two-element List should not be empty", (boolean)this.twoElementList.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertFalse((boolean)this.emptyList.contains((Object)this.exampleIntColumn));
        Assert.assertFalse((boolean)this.emptyList.contains((Object)this.exampleStringColumn));
        Assert.assertTrue((boolean)this.oneElementList.contains((Object)this.oneElementList.get(0)));
        Assert.assertFalse((boolean)this.oneElementList.contains((Object)this.exampleStringColumn));
        Assert.assertTrue((boolean)this.twoElementList.contains((Object)this.twoElementList.get(0)));
        Assert.assertTrue((boolean)this.twoElementList.contains((Object)this.twoElementList.get(1)));
        Assert.assertFalse((boolean)this.twoElementList.contains((Object)this.exampleStringColumn));
    }

    @Test
    public void testIterator() throws Exception {
        Assert.assertFalse((boolean)this.emptyList.iterator().hasNext());
        Iterator iterator1 = this.oneElementList.iterator();
        Assert.assertNotNull((Object)iterator1);
        Assert.assertTrue((boolean)iterator1.hasNext());
        Assert.assertEquals(iterator1.next(), (Object)this.oneElementList.get(0));
        Assert.assertFalse((boolean)iterator1.hasNext());
        Iterator iterator2 = this.twoElementList.iterator();
        Assert.assertNotNull((Object)iterator2);
        Assert.assertTrue((boolean)iterator2.hasNext());
        Assert.assertEquals(iterator2.next(), (Object)this.twoElementList.get(0));
        Assert.assertTrue((boolean)iterator2.hasNext());
        Assert.assertEquals(iterator2.next(), (Object)this.twoElementList.get(1));
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    @Test
    public void testToArray() throws Exception {
        Assert.assertEquals((long)0L, (long)this.emptyList.toArray().length);
        Assert.assertEquals((long)1L, (long)this.oneElementList.toArray().length);
        Assert.assertEquals((long)2L, (long)this.twoElementList.toArray().length);
    }

    @Test
    public void testToArrayWithParam() throws Exception {
        ColumnMetaData[] colArray0 = (ColumnMetaData[])this.emptyList.toArray((Object[])new ColumnMetaData[0]);
        Assert.assertEquals((long)0L, (long)colArray0.length);
        ColumnMetaData[] colArray1 = (ColumnMetaData[])this.oneElementList.toArray((Object[])new ColumnMetaData[0]);
        Assert.assertEquals((long)1L, (long)colArray1.length);
        ColumnMetaData[] colArray2 = (ColumnMetaData[])this.twoElementList.toArray((Object[])new ColumnMetaData[0]);
        Assert.assertEquals((long)2L, (long)colArray2.length);
    }

    @Test
    public void testIndexOf() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.emptyList.indexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)-1L, (long)this.oneElementList.indexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)-1L, (long)this.twoElementList.indexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)0L, (long)this.oneElementList.indexOf((Object)this.oneElementList.get(0)));
        Assert.assertEquals((long)0L, (long)this.twoElementList.indexOf((Object)this.twoElementList.get(0)));
        Assert.assertEquals((long)1L, (long)this.twoElementList.indexOf((Object)this.twoElementList.get(1)));
    }

    @Test
    public void testLastIndexOf() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.emptyList.lastIndexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)-1L, (long)this.oneElementList.lastIndexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)-1L, (long)this.twoElementList.lastIndexOf((Object)this.exampleIntColumn));
        Assert.assertEquals((long)0L, (long)this.oneElementList.lastIndexOf((Object)this.oneElementList.get(0)));
        Assert.assertEquals((long)0L, (long)this.twoElementList.lastIndexOf((Object)this.twoElementList.get(0)));
        Assert.assertEquals((long)1L, (long)this.twoElementList.lastIndexOf((Object)this.twoElementList.get(1)));
    }
}

