/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ConnectionTest
extends JdbcTestBase {
    private static Connection connection;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        Driver.load();
        connection = DriverManager.getConnection("jdbc:drill:zk=local");
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
        executor.shutdown();
    }

    private static void emitSupportExceptionWarning() {
        System.err.println("Note:  Still throwing older-Avatica UnsupportedOperationException instead of less-noncompliant SQLFeatureNotSupportedException");
    }

    @Test
    public void testCreateStatementBasicCaseWorks() throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("VALUES 1");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testPrepareStatementBasicCaseWorks() throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("VALUES 1");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testPrepareCallThrows() throws SQLException {
        try {
            connection.prepareCall("VALUES 1");
        }
        catch (UnsupportedOperationException e) {
            ConnectionTest.emitSupportExceptionWarning();
            throw new SQLFeatureNotSupportedException("Note: Still throwing UnsupportedOperationException ", e);
        }
    }

    @Test
    public void testCreateStatement_overload2_supportedCase_returns() throws SQLException {
        connection.createStatement(1003, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testCreateStatement_overload2_unsupportedType1_throws() throws SQLException {
        connection.createStatement(1004, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testCreateStatement_overload2_unsupportedType2_throws() throws SQLException {
        connection.createStatement(1005, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testCreateStatement_overload2_unsupportedConcurrency_throws() throws SQLException {
        connection.createStatement(1003, 1008);
    }

    @Test
    public void testPrepareStatement_overload2_supportedCase_returns() throws SQLException {
        connection.prepareStatement("VALUES 1", 1003, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testPrepareStatement_overload2_unsupportedType1_throws() throws SQLException {
        connection.prepareStatement("VALUES 1", 1004, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testPrepareStatement_overload2_unsupportedType2_throws() throws SQLException {
        connection.prepareStatement("VALUES 1", 1005, 1007);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testPrepareStatement_overload2_unsupportedConcurrency_throws() throws SQLException {
        connection.prepareStatement("VALUES 1", 1003, 1008);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testCreateStatement_overload3_unsupportedHoldability_throws() throws SQLException {
        connection.createStatement(1003, 1007, 2);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    @Ignore(value="until unsupported characteristics are rejected")
    public void testPrepareStatement_overload3_unsupportedHoldability_throws() throws SQLException {
        connection.prepareStatement("VALUES 1", 1003, 1007, 2);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testCreateCall_overload3_throws() throws SQLException {
        try {
            connection.prepareCall("VALUES 1", 1003, 1007, 1);
        }
        catch (UnsupportedOperationException e) {
            ConnectionTest.emitSupportExceptionWarning();
            throw new SQLFeatureNotSupportedException("Note: Still throwing UnsupportedOperationException ", e);
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testPrepareStatement_overload4_throws() throws SQLException {
        try {
            connection.prepareStatement("VALUES 1", 1);
        }
        catch (UnsupportedOperationException e) {
            ConnectionTest.emitSupportExceptionWarning();
            throw new SQLFeatureNotSupportedException("Note: Still throwing UnsupportedOperationException ", e);
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testPrepareStatement_overload5_throws() throws SQLException {
        try {
            connection.prepareStatement("VALUES 1", new int[]{1});
        }
        catch (UnsupportedOperationException e) {
            ConnectionTest.emitSupportExceptionWarning();
            throw new SQLFeatureNotSupportedException("Note: Still throwing UnsupportedOperationException ", e);
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testPrepareStatement_overload6_throws() throws SQLException {
        try {
            connection.prepareStatement("VALUES 1 AS colA", new String[]{"colA"});
        }
        catch (UnsupportedOperationException e) {
            ConnectionTest.emitSupportExceptionWarning();
            throw new SQLFeatureNotSupportedException("Note: Still throwing UnsupportedOperationException ", e);
        }
    }

    @Test
    public void testGetNetworkTimeoutSaysNoTimeout() throws SQLException {
        Assert.assertThat((Object)connection.getNetworkTimeout(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testSetNetworkTimeoutAcceptsNotimeoutRequest() throws SQLException {
        connection.setNetworkTimeout(executor, 0);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetNetworkTimeoutRejectsTimeoutRequest() throws SQLException {
        try {
            connection.setNetworkTimeout(executor, 1000);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"Timeout"), (Matcher)CoreMatchers.containsString((String)"timeout")));
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetNetworkTimeoutRejectsTimeoutRequest2() throws SQLException {
        connection.setNetworkTimeout(executor, Integer.MAX_VALUE);
    }

    @Test(expected=InvalidParameterSqlException.class)
    public void testSetNetworkTimeoutRejectsBadTimeoutValue() throws SQLException {
        try {
            connection.setNetworkTimeout(executor, -1);
        }
        catch (InvalidParameterSqlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"milliseconds"), (Matcher)CoreMatchers.containsString((String)"timeout"), (Matcher)CoreMatchers.containsString((String)"Timeout")));
            throw e;
        }
    }

    @Test(expected=InvalidParameterSqlException.class)
    public void testSetNetworkTimeoutRejectsBadExecutorValue() throws SQLException {
        try {
            connection.setNetworkTimeout(null, 1);
        }
        catch (InvalidParameterSqlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"executor"), (Matcher)CoreMatchers.containsString((String)"Executor")));
            throw e;
        }
    }
}

