/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.proxy;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverPropertyInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.PooledConnection;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.serial.SerialJavaObject;
import javax.sql.rowset.spi.SyncFactory;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.proxy.InvocationReporter;

class InvocationReporterImpl
implements InvocationReporter {
    private static final String LINE_PREFIX = "TRACER: ";
    private static final String SETUP_LINE_PREFIX = "TRACER: SETUP: ";
    private static final String WARNING_LINE_PREFIX = "TRACER: WARNING: ";
    private static final String CALL_LINE_PREFIX = "TRACER: CALL:   ";
    private static final String RETURN_LINE_PREFIX = "TRACER: RETURN: ";
    private static final String THROW_LINE_PREFIX = "TRACER: THROW:  ";
    private static final Set<Package> JDBC_PACKAGES;
    private static final SortedSet<Package> PACKAGES_TO_ABBREVIATE;
    private int lastObjNum = 0;
    private Map<Object, String> objectsToIdsMap = new IdentityHashMap<Object, String>();

    InvocationReporterImpl() {
    }

    void reportAbbreviatedPackages() {
        ArrayList<String> names = new ArrayList<String>();
        for (Package p : PACKAGES_TO_ABBREVIATE) {
            names.add(p.getName());
        }
        this.setupMessage("Abbreviating (unique) class names in packages " + StringUtils.join(names, ", ") + ".");
    }

    private void printTraceLine(String line) {
        System.err.println(line);
    }

    private void printWarningLine(String line) {
        this.printTraceLine(WARNING_LINE_PREFIX + line);
    }

    private String getObjectId(Object object) {
        String id;
        if (null == object) {
            id = "n/a";
        } else {
            id = this.objectsToIdsMap.get(object);
            if (null == id) {
                ++this.lastObjNum;
                id = Integer.toString(this.lastObjNum);
                this.objectsToIdsMap.put(object, id);
            }
        }
        return id;
    }

    private String formatType(Class<?> type) {
        String result;
        if (type.isArray()) {
            result = this.formatType(type.getComponentType()) + "[]";
        } else if (PACKAGES_TO_ABBREVIATE.contains(type.getPackage())) {
            int sameSimpleNameCount = 0;
            for (Package p : PACKAGES_TO_ABBREVIATE) {
                try {
                    Class.forName(p.getName() + "." + type.getSimpleName());
                    ++sameSimpleNameCount;
                }
                catch (ClassNotFoundException e) {}
            }
            result = 1 == sameSimpleNameCount ? type.getSimpleName() : type.getName();
        } else {
            result = type.getName();
        }
        return result;
    }

    private String formatString(String value) {
        return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"";
    }

    private String formatDriverPropertyInfo(DriverPropertyInfo info) {
        return "[ name = " + this.formatValue(info.name) + ", value = " + this.formatValue(info.value) + ", required = " + info.required + ", choices = " + this.formatValue(info.choices) + ", description = " + this.formatValue(info.description) + " ]";
    }

    private String formatValue(Object value) {
        String result;
        if (null == value) {
            result = "null";
        } else {
            Class<?> rawActualType = value.getClass();
            if (String.class == rawActualType) {
                result = this.formatString((String)value);
            } else if (rawActualType.isArray() && !rawActualType.getComponentType().isPrimitive()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("{ ");
                boolean first = true;
                for (Object elemVal : (Object[])value) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(this.formatValue(elemVal));
                }
                buffer.append(" }");
                result = buffer.toString();
            } else if (DriverPropertyInfo.class == rawActualType) {
                result = this.formatDriverPropertyInfo((DriverPropertyInfo)value);
            } else if (rawActualType == Boolean.class || rawActualType == Byte.class || rawActualType == Double.class || rawActualType == Float.class || rawActualType == Integer.class || rawActualType == Long.class || rawActualType == Short.class || rawActualType == BigDecimal.class || rawActualType == Class.class || rawActualType == Date.class || rawActualType == Timestamp.class) {
                result = value.toString();
            } else if (rawActualType == Properties.class || rawActualType.isEnum()) {
                result = value.toString();
            } else if (rawActualType == DrillResultSet.class) {
                this.printWarningLine("Class " + rawActualType.getName() + " should be an interface." + " (While it's a class, it can't be proxied, and some methods can't" + " be traced.)");
                result = value.toString();
            } else if (rawActualType.getName().equals("org.apache.hadoop.io.Text") || rawActualType.getName().equals("oadd.org.joda.time.Period") || rawActualType == TimePrintMillis.class) {
                this.printWarningLine("Should " + rawActualType + " be appearing at JDBC interface?");
                result = value.toString();
            } else {
                this.printWarningLine("Unnoted type encountered in formatting (value might not render well): " + rawActualType + ".");
                result = value.toString();
            }
        }
        return result;
    }

    private String formatTypeAndValue(Class<?> declaredType, Object value) {
        String actualValuePart;
        String actualTypePart;
        String declaredTypePart = "(" + this.formatType(declaredType) + ") ";
        if (null == value) {
            actualTypePart = "";
            actualValuePart = this.formatValue(value);
        } else {
            Class<?> origActualType;
            Class<?> rawActualType = value.getClass();
            Class<?> clazz = origActualType = declaredType.isPrimitive() ? declaredType : rawActualType;
            if (String.class == rawActualType) {
                actualTypePart = "";
                actualValuePart = this.formatValue(value);
            } else if (origActualType.isPrimitive()) {
                actualTypePart = "";
                actualValuePart = value.toString();
            } else {
                String idPrefix = "<id=" + this.getObjectId(value) + "> ";
                if (declaredType.isInterface() && JDBC_PACKAGES.contains(declaredType.getPackage())) {
                    actualTypePart = "";
                    actualValuePart = idPrefix + "...";
                } else if (origActualType == declaredType) {
                    actualTypePart = "";
                    actualValuePart = idPrefix + this.formatValue(value);
                } else {
                    actualTypePart = "(" + this.formatType(rawActualType) + ") ";
                    actualValuePart = idPrefix + this.formatValue(value);
                }
            }
        }
        String result = declaredTypePart + actualTypePart + actualValuePart;
        return result;
    }

    private String formatTargetTypeAndValue(Class<?> declaredType, Object value) {
        return this.formatTypeAndValue(declaredType, value);
    }

    private String formatArgTypeAndValue(Class<?> declaredType, Object value) {
        return this.formatTypeAndValue(declaredType, value);
    }

    private String formatReturnTypeAndValue(Class<?> declaredType, Object value) {
        return this.formatTypeAndValue(declaredType, value);
    }

    private String formatThrowable(Throwable thrown) {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (Throwable current = thrown; null != current; current = current.getCause()) {
            if (!first) {
                s.append(" ==> ");
            }
            first = false;
            s.append("(");
            s.append(this.formatType(current.getClass()));
            s.append(") ");
            s.append(this.formatString(current.toString()));
        }
        String result = s.toString();
        return result;
    }

    private String formatArgs(Class<?>[] declaredTypes, Object[] argValues) {
        String result;
        if (null == argValues) {
            result = "()";
        } else {
            StringBuilder s = new StringBuilder();
            s.append("( ");
            for (int ax = 0; ax < argValues.length; ++ax) {
                if (ax > 0) {
                    s.append(", ");
                }
                s.append(this.formatArgTypeAndValue(declaredTypes[ax], argValues[ax]));
            }
            s.append(" )");
            result = s.toString();
        }
        return result;
    }

    private String formatCallPart(Object target, Class<?> targetType, Method method, Object[] argValues) {
        return "(" + this.formatTargetTypeAndValue(targetType, target) + ") . " + method.getName() + this.formatArgs(method.getParameterTypes(), argValues);
    }

    @Override
    public void setupMessage(String message) {
        this.printTraceLine(SETUP_LINE_PREFIX + message);
    }

    @Override
    public void methodCalled(Object target, Class<?> targetType, Method method, Object[] args) {
        this.printTraceLine(CALL_LINE_PREFIX + this.formatCallPart(target, targetType, method, args));
    }

    @Override
    public void methodReturned(Object target, Class<?> targetType, Method method, Object[] args, Object result) {
        String callPart = RETURN_LINE_PREFIX + this.formatCallPart(target, targetType, method, args);
        if (Void.TYPE == method.getReturnType()) {
            assert (null == result) : "unexpected non-null result value " + result + " for method returning " + method.getReturnType();
            this.printTraceLine(callPart + ", RESULT: (none--void) ");
        } else {
            this.printTraceLine(callPart + ", RESULT: " + this.formatReturnTypeAndValue(method.getReturnType(), result));
        }
    }

    @Override
    public void methodThrew(Object target, Class<?> targetType, Method method, Object[] args, Throwable exception) {
        this.printTraceLine(THROW_LINE_PREFIX + this.formatCallPart(target, targetType, method, args) + ", threw: " + this.formatThrowable(exception));
    }

    static {
        Class someReference = Connection.class;
        someReference = PooledConnection.class;
        someReference = BaseRowSet.class;
        someReference = SerialJavaObject.class;
        someReference = SyncFactory.class;
        HashSet<Package> set = new HashSet<Package>();
        set.add(Package.getPackage("java.sql"));
        set.add(Package.getPackage("javax.sql"));
        set.add(Package.getPackage("javax.sql.rowset"));
        set.add(Package.getPackage("javax.sql.rowset.serial"));
        set.add(Package.getPackage("javax.sql.rowset.spi"));
        for (Package p : set) {
            assert (null != p) : "null Package; missing reference to class in that package?";
        }
        JDBC_PACKAGES = Collections.unmodifiableSet(set);
        TreeSet<Package> set2 = new TreeSet<Package>(new Comparator<Package>(){

            @Override
            public int compare(Package o1, Package o2) {
                return null == o1 ? -1 : (null == o2 ? 1 : o1.getName().compareTo(o2.getName()));
            }
        });
        set2.addAll(JDBC_PACKAGES);
        set2.add(Package.getPackage("java.util"));
        set2.add(Package.getPackage("java.lang"));
        PACKAGES_TO_ABBREVIATE = Collections.unmodifiableSortedSet(set2);
    }
}

