/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.serializers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import oadd.com.google.common.collect.Multimap;
import oadd.org.reflections.Reflections;
import oadd.org.reflections.ReflectionsException;
import oadd.org.reflections.serializers.Serializer;
import oadd.org.reflections.util.ConfigurationBuilder;
import oadd.org.reflections.util.Utils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlSerializer
implements Serializer {
    public Reflections read(InputStream inputStream) {
        Document document;
        Reflections reflections = new Reflections(new ConfigurationBuilder());
        try {
            document = new SAXReader().read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        for (Object e1 : document.getRootElement().elements()) {
            Element index = (Element)e1;
            for (Object e2 : index.elements()) {
                Element entry = (Element)e2;
                Element key = entry.element("key");
                Element values = entry.element("values");
                for (Object o3 : values.elements()) {
                    Element value = (Element)o3;
                    reflections.getStore().getOrCreate(index.getName()).put(key.getText(), value.getText());
                }
            }
        }
        return reflections;
    }

    public File save(Reflections reflections, String filename) {
        File file = Utils.prepareFile(filename);
        Document document = this.createDocument(reflections);
        try {
            XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(file), OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ReflectionsException("could not save to file " + filename, e);
        }
        return file;
    }

    public String toString(Reflections reflections) {
        Document document = this.createDocument(reflections);
        try {
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections) {
        Map<String, Multimap<String, String>> map = reflections.getStore().getStoreMap();
        Document document = DocumentFactory.getInstance().createDocument();
        Element root = document.addElement("Reflections");
        for (String indexName : map.keySet()) {
            Element indexElement = root.addElement(indexName);
            for (String key : map.get(indexName).keySet()) {
                Element entryElement = indexElement.addElement("entry");
                entryElement.addElement("key").setText(key);
                Element valuesElement = entryElement.addElement("values");
                for (String value : map.get(indexName).get(key)) {
                    valuesElement.addElement("value").setText(value);
                }
            }
        }
        return document;
    }
}

