/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.user;

import java.util.concurrent.ThreadLocalRandom;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.work.WorkManager;
import oadd.org.apache.drill.exec.work.foreman.Foreman;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWorker {
    static final Logger logger = LoggerFactory.getLogger(UserWorker.class);
    private final WorkManager.WorkerBee bee;
    private final UserSession.QueryCountIncrementer incrementer = new UserSession.QueryCountIncrementer(){

        @Override
        public void increment(UserSession session) {
            session.incrementQueryCount(this);
        }
    };

    public UserWorker(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public UserBitShared.QueryId submitWork(UserServer.UserClientConnection connection, UserProtos.RunQuery query) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        long time = (int)(System.currentTimeMillis() / 1000L);
        long p1 = (Integer.MAX_VALUE - time << 32) + (long)r.nextInt();
        long p2 = r.nextLong();
        UserBitShared.QueryId id = UserBitShared.QueryId.newBuilder().setPart1(p1).setPart2(p2).build();
        this.incrementer.increment(connection.getSession());
        Foreman foreman = new Foreman(this.bee, this.bee.getContext(), connection, id, query);
        this.bee.addNewForeman(foreman);
        return id;
    }

    public GeneralRPCProtos.Ack cancelQuery(UserBitShared.QueryId query) {
        Foreman foreman = this.bee.getForemanForQueryId(query);
        if (foreman != null) {
            foreman.cancel();
        }
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack resumeQuery(UserBitShared.QueryId queryId) {
        Foreman foreman = this.bee.getForemanForQueryId(queryId);
        if (foreman != null) {
            foreman.resume();
        }
        return Acks.OK;
    }

    public OptionManager getSystemOptions() {
        return this.bee.getContext().getOptionManager();
    }
}

