/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableFloat8Vector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableFloat8WriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Float8Writer;

public class NullableFloat8ReaderImpl
extends AbstractFieldReader {
    private final NullableFloat8Vector vector;

    public NullableFloat8ReaderImpl(NullableFloat8Vector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(Float8Writer writer) {
        NullableFloat8WriterImpl impl = (NullableFloat8WriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableFloat8WriterImpl impl = (NullableFloat8WriterImpl)writer.float8(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableFloat8Holder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Double readDouble() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

