/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BitWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Float4Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.Float8Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.IntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.VarCharWriter;

public class MapOrListWriterImpl
implements BaseWriter.MapOrListWriter {
    public final BaseWriter.MapWriter map;
    public final BaseWriter.ListWriter list;

    public MapOrListWriterImpl(BaseWriter.MapWriter writer) {
        this.map = writer;
        this.list = null;
    }

    public MapOrListWriterImpl(BaseWriter.ListWriter writer) {
        this.map = null;
        this.list = writer;
    }

    @Override
    public void start() {
        if (this.map != null) {
            this.map.start();
        } else {
            this.list.startList();
        }
    }

    @Override
    public void end() {
        if (this.map != null) {
            this.map.end();
        } else {
            this.list.endList();
        }
    }

    @Override
    public BaseWriter.MapOrListWriter map(String name) {
        assert (this.map != null);
        return new MapOrListWriterImpl(this.map.map(name));
    }

    @Override
    public BaseWriter.MapOrListWriter listoftmap(String name) {
        assert (this.list != null);
        return new MapOrListWriterImpl(this.list.map());
    }

    @Override
    public BaseWriter.MapOrListWriter list(String name) {
        assert (this.map != null);
        return new MapOrListWriterImpl(this.map.list(name));
    }

    @Override
    public boolean isMapWriter() {
        return this.map != null;
    }

    @Override
    public boolean isListWriter() {
        return this.list != null;
    }

    @Override
    public VarCharWriter varChar(String name) {
        return this.map != null ? this.map.varChar(name) : this.list.varChar();
    }

    @Override
    public IntWriter integer(String name) {
        return this.map != null ? this.map.integer(name) : this.list.integer();
    }

    @Override
    public BigIntWriter bigInt(String name) {
        return this.map != null ? this.map.bigInt(name) : this.list.bigInt();
    }

    @Override
    public Float4Writer float4(String name) {
        return this.map != null ? this.map.float4(name) : this.list.float4();
    }

    @Override
    public Float8Writer float8(String name) {
        return this.map != null ? this.map.float8(name) : this.list.float8();
    }

    @Override
    public BitWriter bit(String name) {
        return this.map != null ? this.map.bit(name) : this.list.bit();
    }

    @Override
    public VarBinaryWriter binary(String name) {
        return this.map != null ? this.map.varBinary(name) : this.list.varBinary();
    }
}

