/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntervalHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.IntervalVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedIntervalReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;

public final class RepeatedIntervalVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private IntervalVector values;
    private final FieldReader reader = new RepeatedIntervalReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedIntervalVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public IntervalVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedIntervalVector)to);
    }

    public AddOrGetResult<IntervalVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<IntervalVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedIntervalVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedIntervalVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedIntervalVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedIntervalVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        boolean success = false;
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedIntervalVector.this);
        }

        public void add(int index, DrillBuf value) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalVector.this.values.getMutator().set(nextOffset, value);
            RepeatedIntervalVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, DrillBuf srcValue) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedIntervalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedIntervalHolder h) {
            IntervalHolder ih = new IntervalHolder();
            IntervalVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedIntervalVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedIntervalVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, IntervalHolder holder) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableIntervalHolder holder) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int arrayIndex, int months, int days, int milliseconds) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(arrayIndex + 1);
            RepeatedIntervalVector.this.values.getMutator().setSafe(nextOffset, months, days, milliseconds);
            RepeatedIntervalVector.this.offsets.getMutator().setSafe(arrayIndex + 1, nextOffset + 1);
        }

        protected void add(int index, IntervalHolder holder) {
            int nextOffset = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedIntervalVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedIntervalHolder holder) {
            IntervalVector.Accessor accessor = holder.vector.getAccessor();
            IntervalHolder innerHolder = new IntervalHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedIntervalVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedIntervalVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedIntervalVector.this);
        }

        @Override
        public List<Period> getObject(int index) {
            JsonStringArrayList<Period> vals = new JsonStringArrayList<Period>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedIntervalVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            IntervalVector.Accessor valuesAccessor = RepeatedIntervalVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Period getSingleObject(int index, int arrayIndex) {
            int start = RepeatedIntervalVector.this.offsets.getAccessor().get(index);
            return RepeatedIntervalVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public DrillBuf get(int index, int positionIndex) {
            return RepeatedIntervalVector.this.values.getAccessor().get(RepeatedIntervalVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedIntervalHolder holder) {
            holder.start = RepeatedIntervalVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedIntervalVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedIntervalVector.this.values;
        }

        public void get(int index, int positionIndex, IntervalHolder holder) {
            int offset = RepeatedIntervalVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedIntervalVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableIntervalHolder holder) {
            int offset = RepeatedIntervalVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedIntervalVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedIntervalVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedIntervalVector(field, allocator);
        }

        public TransferImpl(RepeatedIntervalVector to) {
            this.to = to;
        }

        @Override
        public RepeatedIntervalVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedIntervalVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedIntervalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedIntervalVector.this);
        }
    }
}

