/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oadd.com.fasterxml.jackson.annotation.JsonAutoDetect;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.exec.testing.Injection;
import oadd.org.apache.drill.exec.testing.InjectionConfigurationException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ExceptionInjection
extends Injection {
    private final Class<? extends Throwable> exceptionClass;

    @JsonCreator
    private ExceptionInjection(@JsonProperty(value="address") String address, @JsonProperty(value="port") int port, @JsonProperty(value="siteClass") String siteClass, @JsonProperty(value="desc") String desc, @JsonProperty(value="nSkip") int nSkip, @JsonProperty(value="nFire") int nFire, @JsonProperty(value="exceptionClass") String classString) throws InjectionConfigurationException {
        super(address, port, siteClass, desc, nSkip, nFire);
        Class<?> clazz;
        try {
            clazz = Class.forName(classString);
        }
        catch (ClassNotFoundException e) {
            throw new InjectionConfigurationException("Injected exceptionClass not found.", e);
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new InjectionConfigurationException("Injected exceptionClass is not a Throwable.");
        }
        Class<?> exceptionClazz = clazz;
        this.exceptionClass = exceptionClazz;
    }

    private Throwable constructException() {
        Throwable throwable;
        Constructor<? extends Throwable> constructor;
        if (!this.injectNow()) {
            return null;
        }
        try {
            constructor = this.exceptionClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No constructor found that takes a single String argument.");
        }
        try {
            throwable = constructor.newInstance(this.getDesc());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Couldn't construct exception instance.", e);
        }
        return throwable;
    }

    public void throwUnchecked() {
        Throwable throwable = this.constructException();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)throwable;
            throw e;
        }
        if (throwable instanceof Error) {
            Error e = (Error)throwable;
            throw e;
        }
        throw new IllegalStateException("Throwable was not an unchecked exception.");
    }

    public <T extends Throwable> void throwChecked(Class<T> exceptionClass) throws T {
        Throwable throwable = this.constructException();
        if (throwable == null) {
            return;
        }
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            Throwable exception = (Throwable)exceptionClass.cast(throwable);
            throw exception;
        }
        throw new IllegalStateException("Constructed Throwable(" + throwable.getClass().getName() + ") is incompatible with exceptionClass(" + exceptionClass.getName() + ")");
    }
}

