/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.commons.collections.IteratorUtils;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.compile.ClassTransformer;
import oadd.org.apache.drill.exec.compile.QueryClassLoader;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.server.options.BaseOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.store.sys.PersistentStore;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreConfig;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOptionManager
extends BaseOptionManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SystemOptionManager.class);
    private static final CaseInsensitiveMap<OptionValidator> VALIDATORS;
    private final PersistentStoreConfig<OptionValue> config;
    private final PersistentStoreProvider provider;
    private PersistentStore<OptionValue> options;

    public SystemOptionManager(LogicalPlanPersistence lpPersistence, PersistentStoreProvider provider) {
        this.provider = provider;
        this.config = PersistentStoreConfig.newJacksonBuilder((ObjectMapper)lpPersistence.getMapper(), OptionValue.class).name("sys.options").build();
    }

    public SystemOptionManager init() throws Exception {
        this.options = this.provider.getOrCreateStore(this.config);
        for (Map.Entry option : Lists.newArrayList(this.options.getAll())) {
            String name = (String)option.getKey();
            OptionValidator validator = VALIDATORS.get(name);
            if (validator == null) {
                this.options.delete(name);
                logger.warn("Deleting deprecated option `{}`", (Object)name);
                continue;
            }
            String canonicalName = validator.getOptionName().toLowerCase();
            if (name.equals(canonicalName)) continue;
            logger.warn("Changing option name to lower case `{}`", (Object)name);
            OptionValue value = (OptionValue)option.getValue();
            this.options.delete(name);
            this.options.put(canonicalName, (Object)value);
        }
        return this;
    }

    public static OptionValidator getValidator(String name) {
        OptionValidator validator = VALIDATORS.get(name);
        if (validator == null) {
            throw UserException.validationError().message(String.format("The option '%s' does not exist.", name), new Object[0]).build(logger);
        }
        return validator;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        CaseInsensitiveMap buildList = CaseInsensitiveMap.newHashMap();
        for (Map.Entry<String, OptionValidator> entry : VALIDATORS.entrySet()) {
            buildList.put(entry.getKey(), entry.getValue().getDefault());
        }
        for (Map.Entry<String, OptionValidator> entry : Lists.newArrayList(this.options.getAll())) {
            buildList.put(entry.getKey(), entry.getValue());
        }
        return buildList.values().iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue value = (OptionValue)this.options.get(name.toLowerCase());
        if (value != null) {
            return value;
        }
        OptionValidator validator = SystemOptionManager.getValidator(name);
        return validator.getDefault();
    }

    @Override
    public void setOption(OptionValue value) {
        Preconditions.checkArgument(value.type == OptionValue.OptionType.SYSTEM, "OptionType must be SYSTEM.");
        String name = value.name.toLowerCase();
        OptionValidator validator = SystemOptionManager.getValidator(name);
        validator.validate(value);
        if (this.options.get(name) == null && value.equals(validator.getDefault())) {
            return;
        }
        this.options.put(name, (Object)value);
    }

    @Override
    public void deleteOption(String name, OptionValue.OptionType type) {
        Preconditions.checkArgument(type == OptionValue.OptionType.SYSTEM, "OptionType must be SYSTEM.");
        SystemOptionManager.getValidator(name);
        this.options.delete(name.toLowerCase());
    }

    @Override
    public void deleteAllOptions(OptionValue.OptionType type) {
        Preconditions.checkArgument(type == OptionValue.OptionType.SYSTEM, "OptionType must be SYSTEM.");
        HashSet<String> names = Sets.newHashSet();
        for (Map.Entry entry : Lists.newArrayList(this.options.getAll())) {
            names.add((String)entry.getKey());
        }
        for (String name : names) {
            this.options.delete(name);
        }
    }

    @Override
    public OptionList getOptionList() {
        return (OptionList)IteratorUtils.toList(this.iterator());
    }

    @Override
    public void close() throws Exception {
        this.options.close();
    }

    static {
        OptionValidator[] validators = new OptionValidator[]{PlannerSettings.CONSTANT_FOLDING, PlannerSettings.EXCHANGE, PlannerSettings.HASHAGG, PlannerSettings.STREAMAGG, PlannerSettings.HASHJOIN, PlannerSettings.MERGEJOIN, PlannerSettings.NESTEDLOOPJOIN, PlannerSettings.MULTIPHASE, PlannerSettings.BROADCAST, PlannerSettings.BROADCAST_THRESHOLD, PlannerSettings.BROADCAST_FACTOR, PlannerSettings.NESTEDLOOPJOIN_FACTOR, PlannerSettings.NLJOIN_FOR_SCALAR, PlannerSettings.JOIN_ROW_COUNT_ESTIMATE_FACTOR, PlannerSettings.MUX_EXCHANGE, PlannerSettings.DEMUX_EXCHANGE, PlannerSettings.PRODUCER_CONSUMER, PlannerSettings.PRODUCER_CONSUMER_QUEUE_SIZE, PlannerSettings.HASH_SINGLE_KEY, PlannerSettings.IDENTIFIER_MAX_LENGTH, PlannerSettings.HASH_JOIN_SWAP, PlannerSettings.HASH_JOIN_SWAP_MARGIN_FACTOR, PlannerSettings.PARTITION_SENDER_THREADS_FACTOR, PlannerSettings.PARTITION_SENDER_MAX_THREADS, PlannerSettings.PARTITION_SENDER_SET_THREADS, PlannerSettings.ENABLE_DECIMAL_DATA_TYPE, PlannerSettings.HEP_OPT, PlannerSettings.PLANNER_MEMORY_LIMIT, PlannerSettings.HEP_PARTITION_PRUNING, PlannerSettings.TYPE_INFERENCE, ExecConstants.CAST_TO_NULLABLE_NUMERIC_OPTION, ExecConstants.OUTPUT_FORMAT_VALIDATOR, ExecConstants.PARQUET_BLOCK_SIZE_VALIDATOR, ExecConstants.PARQUET_PAGE_SIZE_VALIDATOR, ExecConstants.PARQUET_DICT_PAGE_SIZE_VALIDATOR, ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR, ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR, ExecConstants.PARQUET_VECTOR_FILL_THRESHOLD_VALIDATOR, ExecConstants.PARQUET_VECTOR_FILL_CHECK_THRESHOLD_VALIDATOR, ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR, ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR, ExecConstants.ENABLE_UNION_TYPE, ExecConstants.TEXT_ESTIMATED_ROW_SIZE, ExecConstants.JSON_EXTENDED_TYPES, ExecConstants.JSON_WRITER_UGLIFY, ExecConstants.JSON_WRITER_SKIPNULLFIELDS, ExecConstants.JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR, ExecConstants.FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR, ExecConstants.MONGO_READER_ALL_TEXT_MODE_VALIDATOR, ExecConstants.MONGO_READER_READ_NUMBERS_AS_DOUBLE_VALIDATOR, ExecConstants.MONGO_BSON_RECORD_READER_VALIDATOR, ExecConstants.HIVE_OPTIMIZE_SCAN_WITH_NATIVE_READERS_VALIDATOR, ExecConstants.SLICE_TARGET_OPTION, ExecConstants.AFFINITY_FACTOR, ExecConstants.MAX_WIDTH_GLOBAL, ExecConstants.MAX_WIDTH_PER_NODE, ExecConstants.ENABLE_QUEUE, ExecConstants.LARGE_QUEUE_SIZE, ExecConstants.QUEUE_THRESHOLD_SIZE, ExecConstants.QUEUE_TIMEOUT, ExecConstants.SMALL_QUEUE_SIZE, ExecConstants.MIN_HASH_TABLE_SIZE, ExecConstants.MAX_HASH_TABLE_SIZE, ExecConstants.EARLY_LIMIT0_OPT, ExecConstants.LATE_LIMIT0_OPT, ExecConstants.ENABLE_MEMORY_ESTIMATION, ExecConstants.MAX_QUERY_MEMORY_PER_NODE, ExecConstants.NON_BLOCKING_OPERATORS_MEMORY, ExecConstants.HASH_JOIN_TABLE_FACTOR, ExecConstants.HASH_AGG_TABLE_FACTOR, ExecConstants.AVERAGE_FIELD_WIDTH, ExecConstants.NEW_VIEW_DEFAULT_PERMS_VALIDATOR, ExecConstants.USE_OLD_ASSIGNMENT_CREATOR_VALIDATOR, ExecConstants.CTAS_PARTITIONING_HASH_DISTRIBUTE_VALIDATOR, ExecConstants.ADMIN_USERS_VALIDATOR, ExecConstants.ADMIN_USER_GROUPS_VALIDATOR, ExecConstants.IMPERSONATION_POLICY_VALIDATOR, QueryClassLoader.JAVA_COMPILER_VALIDATOR, QueryClassLoader.JAVA_COMPILER_JANINO_MAXSIZE, QueryClassLoader.JAVA_COMPILER_DEBUG, ExecConstants.ENABLE_VERBOSE_ERRORS, ExecConstants.ENABLE_WINDOW_FUNCTIONS_VALIDATOR, ClassTransformer.SCALAR_REPLACEMENT_VALIDATOR, ExecConstants.ENABLE_NEW_TEXT_READER, ExecConstants.ENABLE_BULK_LOAD_TABLE_LIST, ExecConstants.BULK_LOAD_TABLE_LIST_BULK_SIZE};
        HashMap<String, OptionValidator> tmp = new HashMap<String, OptionValidator>();
        for (OptionValidator validator : validators) {
            tmp.put(validator.getOptionName(), validator);
        }
        if (AssertionUtil.isAssertionsEnabled()) {
            tmp.put("drill.exec.testing.controls", ExecConstants.DRILLBIT_CONTROLS_VALIDATOR);
        }
        VALIDATORS = CaseInsensitiveMap.newImmutableMap(tmp);
    }
}

