/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OptionValue
implements Comparable<OptionValue> {
    public final String name;
    public final Kind kind;
    public final OptionType type;
    public final Long num_val;
    public final String string_val;
    public final Boolean bool_val;
    public final Double float_val;

    public static OptionValue createLong(OptionType type, String name, long val) {
        return new OptionValue(Kind.LONG, type, name, val, null, null, null);
    }

    public static OptionValue createBoolean(OptionType type, String name, boolean bool) {
        return new OptionValue(Kind.BOOLEAN, type, name, null, null, bool, null);
    }

    public static OptionValue createString(OptionType type, String name, String val) {
        return new OptionValue(Kind.STRING, type, name, null, val, null, null);
    }

    public static OptionValue createDouble(OptionType type, String name, double val) {
        return new OptionValue(Kind.DOUBLE, type, name, null, null, null, val);
    }

    public static OptionValue createOption(Kind kind, OptionType type, String name, String val) {
        switch (kind) {
            case BOOLEAN: {
                return OptionValue.createBoolean(type, name, Boolean.valueOf(val));
            }
            case LONG: {
                return OptionValue.createLong(type, name, Long.valueOf(val));
            }
            case STRING: {
                return OptionValue.createString(type, name, val);
            }
            case DOUBLE: {
                return OptionValue.createDouble(type, name, Double.valueOf(val));
            }
        }
        return null;
    }

    @JsonCreator
    private OptionValue(@JsonProperty(value="kind") Kind kind, @JsonProperty(value="type") OptionType type, @JsonProperty(value="name") String name, @JsonProperty(value="num_val") Long num_val, @JsonProperty(value="string_val") String string_val, @JsonProperty(value="bool_val") Boolean bool_val, @JsonProperty(value="float_val") Double float_val) {
        Preconditions.checkArgument(num_val != null || string_val != null || bool_val != null || float_val != null);
        this.kind = kind;
        this.type = type;
        this.name = name;
        this.float_val = float_val;
        this.num_val = num_val;
        this.string_val = string_val;
        this.bool_val = bool_val;
    }

    @JsonIgnore
    public Object getValue() {
        switch (this.kind) {
            case BOOLEAN: {
                return this.bool_val;
            }
            case LONG: {
                return this.num_val;
            }
            case STRING: {
                return this.string_val;
            }
            case DOUBLE: {
                return this.float_val;
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bool_val == null ? 0 : this.bool_val.hashCode());
        result = 31 * result + (this.float_val == null ? 0 : this.float_val.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.num_val == null ? 0 : this.num_val.hashCode());
        result = 31 * result + (this.string_val == null ? 0 : this.string_val.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equalsIgnoreType(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionValue other = (OptionValue)obj;
        if (this.bool_val == null ? other.bool_val != null : !this.bool_val.equals(other.bool_val)) {
            return false;
        }
        if (this.float_val == null ? other.float_val != null : !this.float_val.equals(other.float_val)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.num_val == null ? other.num_val != null : !this.num_val.equals(other.num_val)) {
            return false;
        }
        return !(this.string_val == null ? other.string_val != null : !this.string_val.equals(other.string_val));
    }

    public boolean equals(Object obj) {
        if (!this.equalsIgnoreType(obj)) {
            return false;
        }
        OptionValue other = (OptionValue)obj;
        return this.type == other.type;
    }

    @Override
    public int compareTo(OptionValue o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "OptionValue [type=" + (Object)((Object)this.type) + ", name=" + this.name + ", value=" + this.getValue() + "]";
    }

    public static enum Kind {
        BOOLEAN,
        LONG,
        STRING,
        DOUBLE;

    }

    public static enum OptionType {
        BOOT,
        SYSTEM,
        SESSION,
        QUERY;

    }
}

