/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import oadd.com.carrotsearch.hppc.LongObjectHashMap;
import oadd.com.carrotsearch.hppc.predicates.LongObjectPredicate;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;

public class BufferManagerImpl
implements BufferManager {
    private LongObjectHashMap<DrillBuf> managedBuffers = new LongObjectHashMap();
    private final BufferAllocator allocator;

    public BufferManagerImpl(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void close() {
        this.managedBuffers.forEach(new LongObjectPredicate<DrillBuf>(){

            @Override
            public boolean apply(long key, DrillBuf value) {
                value.release();
                return true;
            }
        });
        this.managedBuffers.clear();
    }

    @Override
    public DrillBuf replace(DrillBuf old, int newSize) {
        if (this.managedBuffers.remove(old.memoryAddress()) == null) {
            throw new IllegalStateException("Tried to remove unmanaged buffer.");
        }
        old.release(1);
        return this.getManagedBuffer(newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.getManagedBuffer(256);
    }

    @Override
    public DrillBuf getManagedBuffer(int size) {
        DrillBuf newBuf = this.allocator.buffer(size, this);
        this.managedBuffers.put(newBuf.memoryAddress(), newBuf);
        return newBuf;
    }
}

