/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.Iterator;
import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.google.common.collect.Iterators;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.calcite.rel.RelFieldCollation;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.logical.data.AbstractSingleBuilder;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.SingleInputOperator;
import oadd.org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="order")
public class Order
extends SingleInputOperator {
    private final Ordering[] orderings;
    private final FieldReference within;

    @JsonCreator
    public Order(@JsonProperty(value="within") FieldReference within, Ordering ... orderings) {
        this.orderings = orderings;
        this.within = within;
    }

    public Ordering[] getOrderings() {
        return this.orderings;
    }

    public FieldReference getWithin() {
        return this.within;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitOrder(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Order, Builder> {
        private List<Ordering> orderings = Lists.newArrayList();
        private FieldReference within;

        public Builder setWithin(FieldReference within) {
            this.within = within;
            return this;
        }

        public Builder addOrdering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection collation) {
            this.orderings.add(new Ordering(direction, e, collation));
            return this;
        }

        @Override
        public Order internalBuild() {
            return new Order(this.within, this.orderings.toArray(new Ordering[this.orderings.size()]));
        }
    }

    public static class Ordering {
        private final LogicalExpression expr;
        private final RelFieldCollation.Direction direction;
        private final RelFieldCollation.NullDirection nullOrdering;

        @JsonCreator
        public Ordering(@JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="order") String strOrderingSpec, @JsonProperty(value="nullDirection") String strNullOrdering) {
            this.expr = expr;
            this.direction = Ordering.getOrderingSpecFromString(strOrderingSpec);
            this.nullOrdering = Ordering.getNullOrderingFromString(strNullOrdering);
        }

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection nullOrdering) {
            this.expr = e;
            this.direction = direction;
            this.nullOrdering = nullOrdering;
        }

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e) {
            this(direction, e, RelFieldCollation.NullDirection.FIRST);
        }

        private static RelFieldCollation.Direction getOrderingSpecFromString(String strDirection) {
            RelFieldCollation.Direction direction;
            if (null == strDirection || RelFieldCollation.Direction.ASCENDING.shortString.equals(strDirection)) {
                direction = RelFieldCollation.Direction.ASCENDING;
            } else if (RelFieldCollation.Direction.DESCENDING.shortString.equals(strDirection)) {
                direction = RelFieldCollation.Direction.DESCENDING;
            } else {
                throw new DrillRuntimeException("Unknown <ordering specification> string (not \"ASC\", \"DESC\", or null): \"" + strDirection + "\"");
            }
            return direction;
        }

        private static RelFieldCollation.NullDirection getNullOrderingFromString(String strNullOrdering) {
            RelFieldCollation.NullDirection nullOrdering;
            if (null == strNullOrdering) {
                nullOrdering = RelFieldCollation.NullDirection.UNSPECIFIED;
            } else {
                try {
                    nullOrdering = RelFieldCollation.NullDirection.valueOf((String)strNullOrdering);
                }
                catch (IllegalArgumentException e) {
                    throw new DrillRuntimeException("Internal error:  Unknown <null ordering> string (not \"" + RelFieldCollation.NullDirection.FIRST.name() + "\", " + "\"" + RelFieldCollation.NullDirection.LAST.name() + "\", or " + "\"" + RelFieldCollation.NullDirection.UNSPECIFIED.name() + "\" or null): " + "\"" + strNullOrdering + "\"");
                }
            }
            return nullOrdering;
        }

        public String toString() {
            return super.toString() + "[ " + " expr = " + this.expr + ", direction = " + this.direction + ", nullOrdering = " + this.nullOrdering + "] ";
        }

        @JsonIgnore
        public RelFieldCollation.Direction getDirection() {
            return this.direction;
        }

        public LogicalExpression getExpr() {
            return this.expr;
        }

        public String getOrder() {
            switch (this.direction) {
                case ASCENDING: {
                    return RelFieldCollation.Direction.ASCENDING.shortString;
                }
                case DESCENDING: {
                    return RelFieldCollation.Direction.DESCENDING.shortString;
                }
            }
            throw new DrillRuntimeException("Unexpected " + RelFieldCollation.Direction.class.getName() + " value other than " + RelFieldCollation.Direction.ASCENDING + " or " + RelFieldCollation.Direction.DESCENDING + ": " + this.direction);
        }

        public RelFieldCollation.NullDirection getNullDirection() {
            return this.nullOrdering;
        }

        public boolean nullsSortHigh() {
            boolean nullsHigh;
            switch (this.nullOrdering) {
                case UNSPECIFIED: {
                    nullsHigh = true;
                    break;
                }
                case FIRST: {
                    nullsHigh = RelFieldCollation.Direction.DESCENDING == this.getDirection();
                    break;
                }
                case LAST: {
                    nullsHigh = RelFieldCollation.Direction.ASCENDING == this.getDirection();
                    break;
                }
                default: {
                    throw new DrillRuntimeException("Unexpected " + RelFieldCollation.NullDirection.class.getName() + " value other than " + RelFieldCollation.NullDirection.FIRST + ", " + RelFieldCollation.NullDirection.LAST + " or " + RelFieldCollation.NullDirection.UNSPECIFIED + ": " + this.nullOrdering);
                }
            }
            return nullsHigh;
        }
    }
}

