/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCallFactory {
    static final Logger logger = LoggerFactory.getLogger(FunctionCallFactory.class);
    private static Map<String, String> opToFuncTable = new HashMap<String, String>();

    public static String replaceOpWithFuncName(String op) {
        return opToFuncTable.containsKey(op) ? opToFuncTable.get(op) : op;
    }

    public static boolean isBooleanOperator(String funcName) {
        String opName = FunctionCallFactory.replaceOpWithFuncName(funcName);
        return opName.equals("booleanAnd") || opName.equals("booleanOr");
    }

    public static LogicalExpression createCast(TypeProtos.MajorType type, ExpressionPosition ep, LogicalExpression expr) {
        return new CastExpression(expr, type, ep);
    }

    public static LogicalExpression createConvert(String function, String conversionType, LogicalExpression expr, ExpressionPosition ep) {
        return new ConvertExpression(function, conversionType, expr, ep);
    }

    public static LogicalExpression createExpression(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createExpression(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        String name = FunctionCallFactory.replaceOpWithFuncName(functionName);
        if (FunctionCallFactory.isBooleanOperator(name)) {
            return new BooleanOperator(name, args, ep);
        }
        return new FunctionCall(name, args, ep);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, LogicalExpression ... e) {
        return FunctionCallFactory.createExpression(functionName, ep, Lists.newArrayList(e));
    }

    public static LogicalExpression createBooleanOperator(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createBooleanOperator(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createBooleanOperator(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        return new BooleanOperator(FunctionCallFactory.replaceOpWithFuncName(functionName), args, ep);
    }

    public static LogicalExpression createByOp(List<LogicalExpression> args, ExpressionPosition ep, List<String> opTypes) {
        if (args.size() == 1) {
            return args.get(0);
        }
        if (args.size() - 1 != opTypes.size()) {
            throw new DrillRuntimeException("Must receive one more expression then the provided number of operators.");
        }
        LogicalExpression first = args.get(0);
        for (int i = 0; i < opTypes.size(); ++i) {
            ArrayList<LogicalExpression> l2 = new ArrayList<LogicalExpression>();
            l2.add(first);
            l2.add(args.get(i + 1));
            first = FunctionCallFactory.createExpression(opTypes.get(i), ep, l2);
        }
        return first;
    }

    static {
        opToFuncTable.put("+", "add");
        opToFuncTable.put("-", "subtract");
        opToFuncTable.put("/", "divide");
        opToFuncTable.put("*", "multiply");
        opToFuncTable.put("%", "modulo");
        opToFuncTable.put("^", "xor");
        opToFuncTable.put("||", "concatOperator");
        opToFuncTable.put("or", "booleanOr");
        opToFuncTable.put("and", "booleanAnd");
        opToFuncTable.put(">", "greater_than");
        opToFuncTable.put("<", "less_than");
        opToFuncTable.put("==", "equal");
        opToFuncTable.put("=", "equal");
        opToFuncTable.put("!=", "not_equal");
        opToFuncTable.put("<>", "not_equal");
        opToFuncTable.put(">=", "greater_than_or_equal_to");
        opToFuncTable.put("<=", "less_than_or_equal_to");
        opToFuncTable.put("is null", "isnull");
        opToFuncTable.put("is not null", "isnotnull");
        opToFuncTable.put("is true", "istrue");
        opToFuncTable.put("is not true", "isnottrue");
        opToFuncTable.put("is false", "isfalse");
        opToFuncTable.put("is not false", "isnotfalse");
        opToFuncTable.put("similar to", "similar_to");
        opToFuncTable.put("!", "not");
        opToFuncTable.put("u-", "negative");
    }
}

