/*
 * Decompiled with CFR 0.152.
 */
package oadd.net.hydromatic.avatica;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnMetaData {
    public final int ordinal;
    public final boolean autoIncrement;
    public final boolean caseSensitive;
    public final boolean searchable;
    public final boolean currency;
    public final int nullable;
    public final boolean signed;
    public final int displaySize;
    public final String label;
    public final String columnName;
    public final String schemaName;
    public final int precision;
    public final int scale;
    public final String tableName;
    public final String catalogName;
    public final boolean readOnly;
    public final boolean writable;
    public final boolean definitelyWritable;
    public final String columnClassName;
    public final AvaticaType type;

    public ColumnMetaData(int ordinal, boolean autoIncrement, boolean caseSensitive, boolean searchable, boolean currency, int nullable, boolean signed, int displaySize, String label, String columnName, String schemaName, int precision, int scale, String tableName, String catalogName, AvaticaType type, boolean readOnly, boolean writable, boolean definitelyWritable, String columnClassName) {
        this.ordinal = ordinal;
        this.autoIncrement = autoIncrement;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.currency = currency;
        this.nullable = nullable;
        this.signed = signed;
        this.displaySize = displaySize;
        this.label = label;
        this.columnName = ColumnMetaData.first(columnName, label);
        this.schemaName = schemaName;
        this.precision = precision;
        this.scale = scale;
        this.tableName = tableName;
        this.catalogName = catalogName;
        this.type = type;
        this.readOnly = readOnly;
        this.writable = writable;
        this.definitelyWritable = definitelyWritable;
        this.columnClassName = columnClassName;
    }

    private static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static ScalarType scalar(int type, String typeName, Rep rep) {
        return new ScalarType(type, typeName, rep);
    }

    public static StructType struct(List<ColumnMetaData> columns) {
        return new StructType(columns, "STRUCT", 2002, Rep.OBJECT);
    }

    public static ArrayType array(AvaticaType componentType, String typeName, Rep rep) {
        return new ArrayType(2003, typeName, rep, componentType);
    }

    public static ColumnMetaData dummy(AvaticaType type, boolean nullable) {
        return new ColumnMetaData(0, false, true, false, false, nullable ? 1 : 0, true, -1, null, null, null, -1, -1, null, null, type, true, false, false, null);
    }

    public static class ArrayType
    extends AvaticaType {
        public final AvaticaType component;

        private ArrayType(int type, String typeName, Rep representation, AvaticaType component) {
            super(type, typeName, representation);
            this.component = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructType
    extends AvaticaType {
        public final List<ColumnMetaData> columns;

        private StructType(List<ColumnMetaData> columns, String typeName, int type, Rep representation) {
            super(type, typeName, representation);
            this.columns = columns;
        }
    }

    public static class ScalarType
    extends AvaticaType {
        public ScalarType(int type, String typeName, Rep representation) {
            super(type, typeName, representation);
        }
    }

    public static class AvaticaType {
        public final int type;
        public final String typeName;
        public final Rep representation;

        protected AvaticaType(int type, String typeName, Rep representation) {
            this.type = type;
            this.typeName = typeName;
            this.representation = representation;
            assert (representation != null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rep {
        PRIMITIVE_BOOLEAN(Boolean.TYPE),
        PRIMITIVE_BYTE(Byte.TYPE),
        PRIMITIVE_CHAR(Character.TYPE),
        PRIMITIVE_SHORT(Short.TYPE),
        PRIMITIVE_INT(Integer.TYPE),
        PRIMITIVE_LONG(Long.TYPE),
        PRIMITIVE_FLOAT(Float.TYPE),
        PRIMITIVE_DOUBLE(Double.TYPE),
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        CHARACTER(Character.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        JAVA_SQL_TIME(Time.class),
        JAVA_SQL_TIMESTAMP(Timestamp.class),
        JAVA_SQL_DATE(Date.class),
        JAVA_UTIL_DATE(java.util.Date.class),
        STRING(String.class),
        OBJECT(Object.class);

        private final Class clazz;
        public static final Map<Class, Rep> VALUE_MAP;

        private Rep(Class clazz) {
            this.clazz = clazz;
        }

        public static Rep of(Type clazz) {
            Rep rep = VALUE_MAP.get(clazz);
            return rep != null ? rep : OBJECT;
        }

        static {
            HashMap<Class, Rep> builder = new HashMap<Class, Rep>();
            for (Rep rep : Rep.values()) {
                builder.put(rep.clazz, rep);
            }
            VALUE_MAP = Collections.unmodifiableMap(builder);
        }
    }
}

