/*
 * Decompiled with CFR 0.152.
 */
package oadd.net.hydromatic.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oadd.net.hydromatic.avatica.AvaticaConnection;
import oadd.net.hydromatic.avatica.AvaticaParameter;
import oadd.net.hydromatic.avatica.AvaticaPrepareResult;
import oadd.net.hydromatic.avatica.AvaticaStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AvaticaPreparedStatement
extends AvaticaStatement
implements PreparedStatement,
ParameterMetaData {
    private final AvaticaPrepareResult prepareResult;
    private final ResultSetMetaData resultSetMetaData;

    protected AvaticaPreparedStatement(AvaticaConnection connection, AvaticaPrepareResult prepareResult, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.prepareResult = prepareResult;
        this.resultSetMetaData = connection.factory.newResultSetMetaData(this, prepareResult.getColumnList());
    }

    @Override
    protected List<Object> getParameterValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (AvaticaParameter parameter : this.prepareResult.getParameterList()) {
            list.add(parameter.value == AvaticaParameter.DUMMY_VALUE ? null : parameter.value);
        }
        return list;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.getConnection().executeQueryInternal(this, this.prepareResult);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this;
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getParameter(parameterIndex).setNull(sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getParameter(parameterIndex).setBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getParameter(parameterIndex).setByte(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getParameter(parameterIndex).setShort(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getParameter(parameterIndex).setInt(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getParameter(parameterIndex).setFloat(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getParameter(parameterIndex).setDouble(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getParameter(parameterIndex).setBigDecimal(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getParameter(parameterIndex).setString(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getParameter(parameterIndex).setBytes(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getParameter(parameterIndex).setDate(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getParameter(parameterIndex).setTime(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getParameter(parameterIndex).setTimestamp(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setAsciiStream(x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setUnicodeStream(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setBinaryStream(x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getParameter(parameterIndex).setObject(x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getParameter(parameterIndex).setObject(x);
    }

    @Override
    public boolean execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getParameter(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getParameter(parameterIndex).setRef(x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getParameter(parameterIndex).setBlob(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getParameter(parameterIndex).setClob(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getParameter(parameterIndex).setArray(x);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.resultSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setDate(x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setTime(x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setTimestamp(x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getParameter(parameterIndex).setNull(sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getParameter(parameterIndex).setURL(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getParameter(parameterIndex).setObject(x, targetSqlType, scaleOrLength);
    }

    protected AvaticaParameter getParameter(int param) throws SQLException {
        try {
            return this.prepareResult.getParameterList().get(param - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.connection.helper.toSQLException(this.connection.helper.createException("parameter ordinal " + param + " out of range"));
        }
    }

    @Override
    public int getParameterCount() {
        return this.prepareResult.getParameterList().size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.getParameter((int)index).signed;
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return this.getParameter((int)index).precision;
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.getParameter((int)index).scale;
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        return this.getParameter((int)index).parameterType;
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        return this.getParameter((int)index).typeName;
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        return this.getParameter((int)index).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        AvaticaParameter paramDef = this.getParameter(param);
        return 1;
    }
}

