/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.handler.codec.serialization;

import java.io.Serializable;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufOutputStream;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.MessageToByteEncoder;
import oadd.io.netty.handler.codec.serialization.CompactObjectOutputStream;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(msg);
        oout.flush();
        oout.close();
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

