/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import org.apache.drill.jdbc.DrillbitClassLoader;
import org.apache.drill.jdbc.Driver;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITTestShadedJar {
    private static DrillbitClassLoader drillbitLoader;
    private static URLClassLoader rootClassLoader;

    private static URL getJdbcUrl() throws MalformedURLException {
        return new URL(String.format("%s../../target/drill-jdbc-all-%s.jar", ClassLoader.getSystemClassLoader().getResource("").toString(), System.getProperty("project.version")));
    }

    @Test
    public void executeJdbcAllQuery() throws Exception {
        System.out.println("java.class.path:");
        System.out.println(System.getProperty("java.class.path"));
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)loader, ITTestShadedJar.getJdbcUrl());
        Class<?> clazz = loader.loadClass("org.apache.drill.jdbc.Driver");
        Driver driver = (Driver)clazz.newInstance();
        try (Connection c = driver.connect("jdbc:drill:drillbit=localhost:31010", null);
             Statement s = c.createStatement();
             ResultSet result = s.executeQuery("select * from (VALUES 1)");){
            while (result.next()) {
                System.out.println(result.getObject(1));
            }
        }
    }

    @BeforeClass
    public static void setupDefaultTestCluster() throws Exception {
        drillbitLoader = new DrillbitClassLoader();
        rootClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        try {
            ITTestShadedJar.runWithLoader("DrillbitStartThread", drillbitLoader);
        }
        catch (Exception e) {
            ITTestShadedJar.printClassesLoaded("root", rootClassLoader);
            throw e;
        }
    }

    @AfterClass
    public static void closeClient() throws Exception {
        ITTestShadedJar.runWithLoader("DrillbitStopThread", drillbitLoader);
    }

    private static int getClassesLoadedCount(ClassLoader classLoader) {
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            Vector classes = (Vector)f.get(classLoader);
            return classes.size();
        }
        catch (Exception e) {
            System.out.println("Failure while loading class count.");
            return -1;
        }
    }

    private static void printClassesLoaded(String prefix, ClassLoader classLoader) {
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            Vector classes = (Vector)f.get(classLoader);
            for (Class c : classes) {
                System.out.println(prefix + ": " + c.getName());
            }
        }
        catch (Exception e) {
            System.out.println("Failure while printing loaded classes.");
        }
    }

    private static void runWithLoader(String name, ClassLoader loader) throws Exception {
        Class<?> clazz = loader.loadClass(ITTestShadedJar.class.getName() + "$" + name);
        Object o = clazz.getDeclaredConstructors()[0].newInstance(loader);
        clazz.getMethod("go", new Class[0]).invoke(o, new Object[0]);
    }

    public static class DrillbitStopThread
    extends AbstractLoaderThread {
        public DrillbitStopThread(ClassLoader loader) {
            super(loader);
        }

        @Override
        protected void internalRun() throws Exception {
            Class<?> clazz = this.loader.loadClass("org.apache.drill.BaseTestQuery");
            clazz.getMethod("setupDefaultTestCluster", new Class[0]).invoke(null, new Object[0]);
        }
    }

    public static class DrillbitStartThread
    extends AbstractLoaderThread {
        public DrillbitStartThread(ClassLoader loader) {
            super(loader);
        }

        @Override
        protected void internalRun() throws Exception {
            Class<?> clazz = this.loader.loadClass("org.apache.drill.BaseTestQuery");
            clazz.getMethod("setupDefaultTestCluster", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("testNoResult", String.class, new Object[0].getClass()).invoke(null, "select * from (VALUES 1)", new Object[0]);
        }
    }

    public static abstract class AbstractLoaderThread
    extends Thread {
        private Exception ex;
        protected final ClassLoader loader;

        public AbstractLoaderThread(ClassLoader loader) {
            this.setContextClassLoader(loader);
            this.loader = loader;
        }

        @Override
        public final void run() {
            try {
                this.internalRun();
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        protected abstract void internalRun() throws Exception;

        public void go() throws Exception {
            this.start();
            this.join();
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }
}

