/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class DrillbitClassLoader
extends URLClassLoader {
    private static final URL[] URLS;

    public DrillbitClassLoader() {
        super(URLS);
    }

    private static String[] fracture(String str, String sep) {
        String s;
        if (str.length() == 0) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        int in = 0;
        int curPos = 0;
        int i = str.indexOf(sep);
        int len = sep.length();
        while (i != -1) {
            s = str.substring(curPos, i);
            res.add(s);
            ++in;
            curPos = i + len;
            i = str.indexOf(sep, curPos);
        }
        len = str.length();
        if (curPos <= len) {
            s = str.substring(curPos, len);
            ++in;
            res.add(s);
        }
        return res.toArray(new String[in]);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    static {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String classPath = System.getProperty("app.class.path");
        String[] st = DrillbitClassLoader.fracture(classPath, File.pathSeparator);
        int l = st.length;
        for (int i = 0; i < l; ++i) {
            try {
                if (st[i].length() == 0) {
                    st[i] = ".";
                }
                urlList.add(new File(st[i]).toURI().toURL());
                continue;
            }
            catch (MalformedURLException e) {
                assert (false) : e.toString();
                continue;
            }
        }
        urlList.toArray(new URL[urlList.size()]);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : urlList) {
            urls.add(url);
        }
        URLS = urls.toArray(new URL[urls.size()]);
    }
}

