
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import io.netty.buffer.ByteBuf;

@SuppressWarnings("unused")

public class DecimalMaxFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(MaxFunctions.class);


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal9Max implements DrillAggFunc{

  @Param Decimal9Holder in;
  @Workspace Decimal9Holder value;
  @Output Decimal9Holder out;

  public void setup() {
    value = new Decimal9Holder();
    value.value = Integer.MIN_VALUE;

  }

  @Override
  public void add() {
    value.value = Math.max(value.value, in.value);
  }

  @Override
  public void output() {
    out.value = value.value;
    out.scale = value.scale;
    out.precision = value.precision;
  }

  @Override
  public void reset() {

    value = new Decimal9Holder();
    value.value = Integer.MIN_VALUE;

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal9Max implements DrillAggFunc{

  @Param NullableDecimal9Holder in;
  @Workspace Decimal9Holder value;
  @Output Decimal9Holder out;

  public void setup() {
    value = new Decimal9Holder();
    value.value = Integer.MIN_VALUE;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value = Math.max(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
    out.scale = value.scale;
    out.precision = value.precision;
  }

  @Override
  public void reset() {

    value = new Decimal9Holder();
    value.value = Integer.MIN_VALUE;

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal18Max implements DrillAggFunc{

  @Param Decimal18Holder in;
  @Workspace Decimal18Holder value;
  @Output Decimal18Holder out;

  public void setup() {
    value = new Decimal18Holder();
    value.value = Long.MIN_VALUE;

  }

  @Override
  public void add() {
    value.value = Math.max(value.value, in.value);
  }

  @Override
  public void output() {
    out.value = value.value;
    out.scale = value.scale;
    out.precision = value.precision;
  }

  @Override
  public void reset() {

    value = new Decimal18Holder();
    value.value = Long.MIN_VALUE;

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal18Max implements DrillAggFunc{

  @Param NullableDecimal18Holder in;
  @Workspace Decimal18Holder value;
  @Output Decimal18Holder out;

  public void setup() {
    value = new Decimal18Holder();
    value.value = Long.MIN_VALUE;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value = Math.max(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
    out.scale = value.scale;
    out.precision = value.precision;
  }

  @Override
  public void reset() {

    value = new Decimal18Holder();
    value.value = Long.MIN_VALUE;

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal28SparseMax implements DrillAggFunc{

  @Param Decimal28SparseHolder in;
  @Inject DrillBuf buffer;
  @Workspace IntHolder scale;
  @Workspace IntHolder precision;
  @Workspace ObjectHolder value;
  @Output Decimal28SparseHolder out;

  public void setup() {
    scale.value = 0;
    precision.value = 0;
    value = new ObjectHolder();
    //Decimal28SparseHolder tmp = new Decimal28SparseHolder();
    byte[] byteArray = new byte[Decimal28SparseHolder.WIDTH];
    org.apache.drill.exec.util.Text tmp = new org.apache.drill.exec.util.Text(byteArray);
    value.obj = tmp;
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

  @Override
  public void add() {
      //Decimal28SparseHolder tmp = (Decimal28SparseHolder) value.obj;
      org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
      int cmp = org.apache.drill.exec.util.DecimalUtility.compareSparseSamePrecScale(in.buffer, in.start, tmp.getBytes(), tmp.getLength());
    if (cmp == 1) {
      //in.buffer.getBytes(in.start, tmp.getBytes(), 0, Decimal28SparseHolder.WIDTH);
      for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
        org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, Decimal28SparseHolder.getInteger(i, in.start, in.buffer));
      }
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), in.getSign(in.start, in.buffer));
      scale.value = in.scale;
      precision.value = in.precision;
    }
  }

  @Override
  public void output() {
    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    buffer = buffer.reallocIfNeeded(tmp.getLength());
    //buffer.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      Decimal28SparseHolder.setInteger(i, org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getInteger(tmp.getBytes(), i), 0, buffer);
    }
    out.buffer = buffer;
    out.start = 0;
    out.setSign(org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getSign(tmp.getBytes()), out.start, out.buffer);
    out.scale = scale.value;
    out.precision = precision.value;
  }

  @Override
  public void reset() {

    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    scale.value = 0;
    precision.value = 0;
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal28SparseMax implements DrillAggFunc{

  @Param NullableDecimal28SparseHolder in;
  @Inject DrillBuf buffer;
  @Workspace IntHolder scale;
  @Workspace IntHolder precision;
  @Workspace ObjectHolder value;
  @Output Decimal28SparseHolder out;

  public void setup() {
    scale.value = 0;
    precision.value = 0;
    value = new ObjectHolder();
    //Decimal28SparseHolder tmp = new Decimal28SparseHolder();
    byte[] byteArray = new byte[Decimal28SparseHolder.WIDTH];
    org.apache.drill.exec.util.Text tmp = new org.apache.drill.exec.util.Text(byteArray);
    value.obj = tmp;
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
      //Decimal28SparseHolder tmp = (Decimal28SparseHolder) value.obj;
      org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
      int cmp = org.apache.drill.exec.util.DecimalUtility.compareSparseSamePrecScale(in.buffer, in.start, tmp.getBytes(), tmp.getLength());
    if (cmp == 1) {
      //in.buffer.getBytes(in.start, tmp.getBytes(), 0, Decimal28SparseHolder.WIDTH);
      for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
        org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, Decimal28SparseHolder.getInteger(i, in.start, in.buffer));
      }
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), in.getSign(in.start, in.buffer));
      scale.value = in.scale;
      precision.value = in.precision;
    }
    } // end of sout block
  }

  @Override
  public void output() {
    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    buffer = buffer.reallocIfNeeded(tmp.getLength());
    //buffer.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      Decimal28SparseHolder.setInteger(i, org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getInteger(tmp.getBytes(), i), 0, buffer);
    }
    out.buffer = buffer;
    out.start = 0;
    out.setSign(org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getSign(tmp.getBytes()), out.start, out.buffer);
    out.scale = scale.value;
    out.precision = precision.value;
  }

  @Override
  public void reset() {

    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    for (int i = 0; i < Decimal28SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    scale.value = 0;
    precision.value = 0;
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal38SparseMax implements DrillAggFunc{

  @Param Decimal38SparseHolder in;
  @Inject DrillBuf buffer;
  @Workspace IntHolder scale;
  @Workspace IntHolder precision;
  @Workspace ObjectHolder value;
  @Output Decimal38SparseHolder out;

  public void setup() {
    scale.value = 0;
    precision.value = 0;
    value = new ObjectHolder();
    //Decimal38SparseHolder tmp = new Decimal38SparseHolder();
    byte[] byteArray = new byte[Decimal38SparseHolder.WIDTH];
    org.apache.drill.exec.util.Text tmp = new org.apache.drill.exec.util.Text(byteArray);
    value.obj = tmp;
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

  @Override
  public void add() {
      //Decimal38SparseHolder tmp = (Decimal38SparseHolder) value.obj;
      org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
      int cmp = org.apache.drill.exec.util.DecimalUtility.compareSparseSamePrecScale(in.buffer, in.start, tmp.getBytes(), tmp.getLength());
    if (cmp == 1) {
      //in.buffer.getBytes(in.start, tmp.getBytes(), 0, Decimal38SparseHolder.WIDTH);
      for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
        org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, Decimal38SparseHolder.getInteger(i, in.start, in.buffer));
      }
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), in.getSign(in.start, in.buffer));
      scale.value = in.scale;
      precision.value = in.precision;
    }
  }

  @Override
  public void output() {
    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    buffer = buffer.reallocIfNeeded(tmp.getLength());
    //buffer.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      Decimal38SparseHolder.setInteger(i, org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getInteger(tmp.getBytes(), i), 0, buffer);
    }
    out.buffer = buffer;
    out.start = 0;
    out.setSign(org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getSign(tmp.getBytes()), out.start, out.buffer);
    out.scale = scale.value;
    out.precision = precision.value;
  }

  @Override
  public void reset() {

    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    scale.value = 0;
    precision.value = 0;
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

 }



@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal38SparseMax implements DrillAggFunc{

  @Param NullableDecimal38SparseHolder in;
  @Inject DrillBuf buffer;
  @Workspace IntHolder scale;
  @Workspace IntHolder precision;
  @Workspace ObjectHolder value;
  @Output Decimal38SparseHolder out;

  public void setup() {
    scale.value = 0;
    precision.value = 0;
    value = new ObjectHolder();
    //Decimal38SparseHolder tmp = new Decimal38SparseHolder();
    byte[] byteArray = new byte[Decimal38SparseHolder.WIDTH];
    org.apache.drill.exec.util.Text tmp = new org.apache.drill.exec.util.Text(byteArray);
    value.obj = tmp;
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
      //Decimal38SparseHolder tmp = (Decimal38SparseHolder) value.obj;
      org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
      int cmp = org.apache.drill.exec.util.DecimalUtility.compareSparseSamePrecScale(in.buffer, in.start, tmp.getBytes(), tmp.getLength());
    if (cmp == 1) {
      //in.buffer.getBytes(in.start, tmp.getBytes(), 0, Decimal38SparseHolder.WIDTH);
      for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
        org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, Decimal38SparseHolder.getInteger(i, in.start, in.buffer));
      }
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), in.getSign(in.start, in.buffer));
      scale.value = in.scale;
      precision.value = in.precision;
    }
    } // end of sout block
  }

  @Override
  public void output() {
    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    buffer = buffer.reallocIfNeeded(tmp.getLength());
    //buffer.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      Decimal38SparseHolder.setInteger(i, org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getInteger(tmp.getBytes(), i), 0, buffer);
    }
    out.buffer = buffer;
    out.start = 0;
    out.setSign(org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.getSign(tmp.getBytes()), out.start, out.buffer);
    out.scale = scale.value;
    out.precision = precision.value;
  }

  @Override
  public void reset() {

    org.apache.drill.exec.util.Text tmp = (org.apache.drill.exec.util.Text) value.obj;
    for (int i = 0; i < Decimal38SparseHolder.nDecimalDigits; i++) {
      org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setInteger(tmp.getBytes(), i, 0xFFFFFFFF);
    }
    scale.value = 0;
    precision.value = 0;
    org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.setSign(tmp.getBytes(), true);

  }

 }


}
