/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestFragmentExecutorCancel
extends BaseTestQuery {
    @Test
    public void testCancelNonRunningFragments() throws Exception {
        TestFragmentExecutorCancel.test("alter session set `planner.slice_target` = 10");
        CoordinationProtos.DrillbitEndpoint endpoint = bits[0].getContext().getEndpoint();
        String controlsString = "{\"injections\":[{\"address\":\"" + endpoint.getAddress() + "\"," + "\"port\":\"" + endpoint.getUserPort() + "\"," + "\"type\":\"exception\"," + "\"siteClass\":\"" + "org.apache.drill.exec.physical.impl.ScanBatch" + "\"," + "\"desc\":\"" + "next-allocate" + "\"," + "\"nSkip\":0," + "\"nFire\":1," + "\"exceptionClass\":\"" + "org.apache.drill.exec.memory.OutOfMemoryException" + "\"" + "}]}";
        ControlsInjectionUtil.setControls(client, controlsString);
        String query = TestFragmentExecutorCancel.getFile("queries/tpch/04.sql");
        try {
            TestFragmentExecutorCancel.test(query);
            Assert.fail((String)"The query should have failed!!!");
        }
        catch (UserException userException) {
            // empty catch block
        }
        try {
            TestFragmentExecutorCancel.closeClient();
        }
        catch (IllegalStateException ex) {
            Assert.fail((String)"failed to close the drillbits properly");
        }
    }
}

