/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpoolingBuffer
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestSpoolingBuffer.class);

    @Test
    public void testMultipleExchangesSingleThread() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        DrillConfig conf = DrillConfig.create((String)"drill-spool-test-module.conf");
        try (Drillbit bit1 = new Drillbit(conf, serviceSet);
             DrillClient client = new DrillClient(conf, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/work/batch/multiple_exchange.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)500024L, (long)count);
        }
    }
}

