/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileTest {
    public static void main(String[] args) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "sync:///");
        System.out.println(FileSystem.getDefaultUri((Configuration)conf));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path("/tmp/testFile");
        FSDataOutputStream out = fs.create(path);
        byte[] s = "hello world".getBytes();
        out.write(s);
        out.sync();
        FSDataInputStream in = fs.open(path);
        byte[] bytes = new byte[s.length];
        in.read(bytes);
        System.out.println(new String(bytes));
        File file = new File("/tmp/testFile");
        FileOutputStream fos = new FileOutputStream(file);
        FileInputStream fis = new FileInputStream(file);
        fos.write(s);
        fos.getFD().sync();
        fis.read(bytes);
        System.out.println(new String(bytes));
        out = fs.create(new Path("/tmp/file"));
        for (int i = 0; i < 100; ++i) {
            bytes = new byte[262144];
            Stopwatch watch = new Stopwatch();
            watch.start();
            out.write(bytes);
            out.sync();
            long t = watch.elapsed(TimeUnit.MILLISECONDS);
            System.out.printf("Elapsed: %d. Rate %d.\n", t, (long)bytes.length * 1000L / t);
        }
    }
}

