/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.fn.JsonWriter;
import org.apache.drill.exec.vector.complex.impl.ComplexWriterImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRepeated {
    private static final DrillConfig drillConfig = DrillConfig.create();
    private static BufferAllocator allocator;

    @BeforeClass
    public static void setupAllocator() {
        allocator = RootAllocatorFactory.newRoot((DrillConfig)drillConfig);
    }

    @AfterClass
    public static void destroyAllocator() {
        allocator.close();
    }

    @Test
    public void listOfList() throws IOException {
        MapVector v = new MapVector("", allocator, null);
        ComplexWriterImpl writer = new ComplexWriterImpl("col", v);
        writer.allocate();
        BaseWriter.MapWriter map = writer.rootAsMap();
        BaseWriter.ListWriter list = map.list("a");
        list.start();
        BaseWriter.ListWriter innerList = list.list();
        IntWriter innerInt = innerList.integer();
        innerList.start();
        IntHolder holder = new IntHolder();
        holder.value = 1;
        innerInt.write(holder);
        holder.value = 2;
        innerInt.write(holder);
        holder.value = 3;
        innerInt.write(holder);
        innerList.end();
        innerList.start();
        holder.value = 4;
        innerInt.write(holder);
        holder.value = 5;
        innerInt.write(holder);
        innerList.end();
        list.end();
        IntWriter numCol = map.integer("nums");
        holder.value = 14;
        numCol.write(holder);
        BaseWriter.MapWriter repeatedMap = map.list("b").map();
        repeatedMap.start();
        holder.value = 1;
        repeatedMap.integer("c").write(holder);
        repeatedMap.end();
        repeatedMap.start();
        holder.value = 2;
        repeatedMap.integer("c").write(holder);
        BigIntHolder h = new BigIntHolder();
        h.value = 15L;
        repeatedMap.bigInt("x").write(h);
        repeatedMap.end();
        map.end();
        writer.setPosition(1);
        map = writer.rootAsMap();
        list = map.list("a");
        list.start();
        innerList = list.list();
        innerInt = innerList.integer();
        innerList.start();
        holder = new IntHolder();
        holder.value = -1;
        innerInt.write(holder);
        holder.value = -2;
        innerInt.write(holder);
        holder.value = -3;
        innerInt.write(holder);
        innerList.end();
        innerList.start();
        holder.value = -4;
        innerInt.write(holder);
        holder.value = -5;
        innerInt.write(holder);
        innerList.end();
        list.end();
        numCol = map.integer("nums");
        holder.value = -28;
        numCol.write(holder);
        repeatedMap = map.list("b").map();
        repeatedMap.start();
        holder.value = -1;
        repeatedMap.integer("c").write(holder);
        repeatedMap.end();
        repeatedMap.start();
        holder.value = -2;
        repeatedMap.integer("c").write(holder);
        h = new BigIntHolder();
        h.value = -30L;
        repeatedMap.bigInt("x").write(h);
        repeatedMap.end();
        map.end();
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        System.out.println("Map of Object[0]: " + ow.writeValueAsString(v.getAccessor().getObject(0)));
        System.out.println("Map of Object[1]: " + ow.writeValueAsString(v.getAccessor().getObject(1)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonWriter jsonWriter = new JsonWriter((OutputStream)stream, true, true);
        FieldReader reader = ((MapVector)v.getChild("col", MapVector.class)).getReader();
        reader.setPosition(0);
        jsonWriter.write(reader);
        reader.setPosition(1);
        jsonWriter.write(reader);
        System.out.print("Json Read: ");
        System.out.println(new String(stream.toByteArray(), Charsets.UTF_8));
        writer.clear();
    }
}

