/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.writer;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.RepeatedBigIntVector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestJsonReader
extends BaseTestQuery {
    private static final boolean VERBOSE_DEBUG = false;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testEmptyList() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/json/emptyLists").toURI().toString();
        String query = String.format("select count(a[0]) as ct from dfs_test.`%s`", root, root);
        TestJsonReader.testBuilder().sqlQuery(query).ordered().baselineColumns("ct").baselineValues(6L).build().run();
    }

    @Test
    public void schemaChange() throws Exception {
        TestJsonReader.test("select b from dfs.`${WORKING_PATH}/src/test/resources/vector/complex/writer/schemaChange/`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFieldSelectionBug() throws Exception {
        try {
            TestJsonReader.testBuilder().sqlQuery("select t.field_4.inner_3 as col_1, t.field_4 as col_2 from cp.`store/json/schema_change_int_to_string.json` t").unOrdered().optionSettingQueriesForTestQuery("alter session set `store.json.all_text_mode` = true").baselineColumns("col_1", "col_2").baselineValues(TestBuilder.mapOf(new Object[0]), TestBuilder.mapOf("inner_1", TestBuilder.listOf(new Object[0]), "inner_3", TestBuilder.mapOf(new Object[0]))).baselineValues(TestBuilder.mapOf("inner_object_field_1", "2"), TestBuilder.mapOf("inner_1", TestBuilder.listOf("1", "2", "3"), "inner_2", "3", "inner_3", TestBuilder.mapOf("inner_object_field_1", "2"))).baselineValues(TestBuilder.mapOf(new Object[0]), TestBuilder.mapOf("inner_1", TestBuilder.listOf("4", "5", "6"), "inner_2", "3", "inner_3", TestBuilder.mapOf(new Object[0]))).go();
        }
        finally {
            TestJsonReader.test("alter session set `store.json.all_text_mode` = false");
        }
    }

    @Test
    public void testSplitAndTransferFailure() throws Exception {
        String testVal = "a string";
        TestJsonReader.testBuilder().sqlQuery("select flatten(config) as flat from cp.`/store/json/null_list.json`").ordered().baselineColumns("flat").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf("a string")).go();
        TestJsonReader.testBuilder().sqlQuery("select flatten(config) as flat from cp.`/store/json/null_list_v2.json`").ordered().baselineColumns("flat").baselineValues(TestBuilder.mapOf("repeated_varchar", TestBuilder.listOf(new Object[0]))).baselineValues(TestBuilder.mapOf("repeated_varchar", TestBuilder.listOf("a string"))).go();
        TestJsonReader.testBuilder().sqlQuery("select flatten(config) as flat from cp.`/store/json/null_list_v3.json`").ordered().baselineColumns("flat").baselineValues(TestBuilder.mapOf("repeated_map", TestBuilder.listOf(TestBuilder.mapOf("repeated_varchar", TestBuilder.listOf(new Object[0]))))).baselineValues(TestBuilder.mapOf("repeated_map", TestBuilder.listOf(TestBuilder.mapOf("repeated_varchar", TestBuilder.listOf("a string"))))).go();
    }

    @Test
    @Ignore(value="DRILL-1824")
    public void schemaChangeValidate() throws Exception {
        TestJsonReader.testBuilder().sqlQuery("select b from dfs.`${WORKING_PATH}/src/test/resources/vector/complex/writer/schemaChange/`").unOrdered().jsonBaselineFile("/vector/complex/writer/expected.json").build().run();
    }

    public void runTestsOnFile(String filename, UserBitShared.QueryType queryType, String[] queries, long[] rowCounts) throws Exception {
        int i = 0;
        for (String query : queries) {
            int rowCount = TestJsonReader.testRunAndPrint(queryType, query);
            Assert.assertEquals((long)rowCounts[i], (long)rowCount);
            System.out.println();
            ++i;
        }
    }

    @Test
    public void testReadCompressed() throws Exception {
        String filepath = "compressed_json.json";
        File f = this.folder.newFile(filepath);
        PrintWriter out = new PrintWriter(f);
        out.println("{\"a\" :5}");
        out.close();
        TestJsonReader.gzipIt(f);
        TestJsonReader.testBuilder().sqlQuery("select * from dfs.`" + f.getPath() + ".gz" + "`").unOrdered().baselineColumns("a").baselineValues(5L).build().run();
        TestJsonReader.testBuilder().sqlQuery("select * from dfs.`" + f.getPath() + "`").unOrdered().baselineColumns("a").baselineValues(5L).build().run();
    }

    public static void gzipIt(File sourceFile) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(sourceFile.getPath() + ".gz"));
        FileInputStream in = new FileInputStream(sourceFile);
        while ((len = in.read(buffer)) > 0) {
            gzos.write(buffer, 0, len);
        }
        in.close();
        gzos.finish();
        gzos.close();
    }

    @Test
    public void testDrill_1419() throws Exception {
        String[] queries = new String[]{"select t.trans_id, t.trans_info.prod_id[0],t.trans_info.prod_id[1] from cp.`/store/json/clicks.json` t limit 5"};
        long[] rowCounts = new long[]{5L};
        String filename = "/store/json/clicks.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
    }

    @Test
    public void testRepeatedCount() throws Exception {
        TestJsonReader.test("select repeated_count(str_list) from cp.`/store/json/json_basic_repeated_varchar.json`");
        TestJsonReader.test("select repeated_count(INT_col) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_count(FLOAT4_col) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_count(VARCHAR_col) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_count(BIT_col) from cp.`/parquet/alltypes_repeated.json`");
    }

    @Test
    public void testRepeatedContains() throws Exception {
        TestJsonReader.test("select repeated_contains(str_list, 'asdf') from cp.`/store/json/json_basic_repeated_varchar.json`");
        TestJsonReader.test("select repeated_contains(INT_col, -2147483648) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_contains(FLOAT4_col, -1000000000000.0) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_contains(VARCHAR_col, 'qwerty' ) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_contains(BIT_col, true) from cp.`/parquet/alltypes_repeated.json`");
        TestJsonReader.test("select repeated_contains(BIT_col, false) from cp.`/parquet/alltypes_repeated.json`");
    }

    @Test
    public void testSingleColumnRead_vector_fill_bug() throws Exception {
        String[] queries = new String[]{"select * from cp.`/store/json/single_column_long_file.json`"};
        long[] rowCounts = new long[]{13512L};
        String filename = "/store/json/single_column_long_file.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
    }

    @Test
    public void testNonExistentColumnReadAlone() throws Exception {
        String[] queries = new String[]{"select non_existent_column from cp.`/store/json/single_column_long_file.json`"};
        long[] rowCounts = new long[]{13512L};
        String filename = "/store/json/single_column_long_file.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
    }

    @Test
    public void testAllTextMode() throws Exception {
        TestJsonReader.test("alter system set `store.json.all_text_mode` = true");
        String[] queries = new String[]{"select * from cp.`/store/json/schema_change_int_to_string.json`"};
        long[] rowCounts = new long[]{3L};
        String filename = "/store/json/schema_change_int_to_string.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
        TestJsonReader.test("alter system set `store.json.all_text_mode` = false");
    }

    @Test
    public void readComplexWithStar() throws Exception {
        List<QueryDataBatch> results = TestJsonReader.testSqlWithResults("select * from cp.`/store/json/test_complex_read_with_star.json`");
        Assert.assertEquals((long)1L, (long)results.size());
        RecordBatchLoader batchLoader = new RecordBatchLoader(TestJsonReader.getAllocator());
        QueryDataBatch batch = results.get(0);
        Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
        Assert.assertEquals((long)3L, (long)batchLoader.getSchema().getFieldCount());
        this.testExistentColumns(batchLoader);
        batch.release();
        batchLoader.clear();
    }

    @Test
    public void testNullWhereListExpected() throws Exception {
        TestJsonReader.test("alter system set `store.json.all_text_mode` = true");
        String[] queries = new String[]{"select * from cp.`/store/json/null_where_list_expected.json`"};
        long[] rowCounts = new long[]{3L};
        String filename = "/store/json/null_where_list_expected.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
        TestJsonReader.test("alter system set `store.json.all_text_mode` = false");
    }

    @Test
    public void testNullWhereMapExpected() throws Exception {
        TestJsonReader.test("alter system set `store.json.all_text_mode` = true");
        String[] queries = new String[]{"select * from cp.`/store/json/null_where_map_expected.json`"};
        long[] rowCounts = new long[]{3L};
        String filename = "/store/json/null_where_map_expected.json";
        this.runTestsOnFile(filename, UserBitShared.QueryType.SQL, queries, rowCounts);
        TestJsonReader.test("alter system set `store.json.all_text_mode` = false");
    }

    @Test
    public void ensureProjectionPushdown() throws Exception {
        TestJsonReader.test("alter system set `store.json.all_text_mode` = false; select  t.field_1, t.field_3.inner_1, t.field_3.inner_2, t.field_4.inner_1 from cp.`store/json/schema_change_int_to_string.json` t");
    }

    @Test
    public void testProjectPushdown() throws Exception {
        String[] queries = new String[]{Files.toString((File)FileUtils.getResourceAsFile((String)"/store/json/project_pushdown_json_physical_plan.json"), (Charset)Charsets.UTF_8)};
        long[] rowCounts = new long[]{3L};
        String filename = "/store/json/schema_change_int_to_string.json";
        TestJsonReader.test("alter system set `store.json.all_text_mode` = false");
        this.runTestsOnFile(filename, UserBitShared.QueryType.PHYSICAL, queries, rowCounts);
        List<QueryDataBatch> results = TestJsonReader.testPhysicalWithResults(queries[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        RecordBatchLoader batchLoader = new RecordBatchLoader(TestJsonReader.getAllocator());
        QueryDataBatch batch = results.get(0);
        Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
        Assert.assertEquals((long)3L, (long)batchLoader.getSchema().getFieldCount());
        this.testExistentColumns(batchLoader);
        batch.release();
        batchLoader.clear();
    }

    @Test
    public void testJsonDirectoryWithEmptyFile() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/json/jsonDirectoryWithEmpyFile").toURI().toString();
        String queryRightEmpty = String.format("select * from dfs_test.`%s`", root);
        TestJsonReader.testBuilder().sqlQuery(queryRightEmpty).unOrdered().baselineColumns("a").baselineValues(1L).build().run();
    }

    private void testExistentColumns(RecordBatchLoader batchLoader) throws SchemaChangeException {
        VectorWrapper vw = batchLoader.getValueAccessorById(RepeatedBigIntVector.class, batchLoader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"field_1"})).getFieldIds());
        Assert.assertEquals((Object)"[1]", (Object)vw.getValueVector().getAccessor().getObject(0).toString());
        Assert.assertEquals((Object)"[5]", (Object)vw.getValueVector().getAccessor().getObject(1).toString());
        Assert.assertEquals((Object)"[5,10,15]", (Object)vw.getValueVector().getAccessor().getObject(2).toString());
        vw = batchLoader.getValueAccessorById(IntVector.class, batchLoader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"field_3", "inner_1"})).getFieldIds());
        Assert.assertNull((Object)vw.getValueVector().getAccessor().getObject(0));
        Assert.assertEquals((Object)2L, (Object)vw.getValueVector().getAccessor().getObject(1));
        Assert.assertEquals((Object)5L, (Object)vw.getValueVector().getAccessor().getObject(2));
        vw = batchLoader.getValueAccessorById(IntVector.class, batchLoader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"field_3", "inner_2"})).getFieldIds());
        Assert.assertNull((Object)vw.getValueVector().getAccessor().getObject(0));
        Assert.assertNull((Object)vw.getValueVector().getAccessor().getObject(1));
        Assert.assertEquals((Object)3L, (Object)vw.getValueVector().getAccessor().getObject(2));
        vw = batchLoader.getValueAccessorById(RepeatedBigIntVector.class, batchLoader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"field_4", "inner_1"})).getFieldIds());
        Assert.assertEquals((Object)"[]", (Object)vw.getValueVector().getAccessor().getObject(0).toString());
        Assert.assertEquals((Object)"[1,2,3]", (Object)vw.getValueVector().getAccessor().getObject(1).toString());
        Assert.assertEquals((Object)"[4,5,6]", (Object)vw.getValueVector().getAccessor().getObject(2).toString());
    }
}

