/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.writer;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.ExecConstants;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExtendedTypes
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestExtendedTypes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkReadWriteExtended() throws Exception {
        String originalFile = "${WORKING_PATH}/src/test/resources/vector/complex/extended.json".replaceAll(Pattern.quote("${WORKING_PATH}"), Matcher.quoteReplacement(TestTools.getWorkingPath()));
        String newTable = "TestExtendedTypes/newjson";
        try {
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = 'json'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName()), new Object[0]);
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = true", ExecConstants.JSON_EXTENDED_TYPES.getOptionName()), new Object[0]);
            TestExtendedTypes.test("create table dfs_test.tmp.`%s` as select * from dfs.`%s`", "TestExtendedTypes/newjson", originalFile);
            TestExtendedTypes.test("select * from dfs_test.tmp.`%s`", "TestExtendedTypes/newjson");
            byte[] originalData = Files.readAllBytes(Paths.get(originalFile, new String[0]));
            byte[] newData = Files.readAllBytes(Paths.get(BaseTestQuery.getDfsTestTmpSchemaLocation() + '/' + "TestExtendedTypes/newjson" + "/0_0_0.json", new String[0]));
            Assert.assertEquals((Object)new String(originalData), (Object)new String(newData));
        }
        catch (Throwable throwable) {
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = '%s'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName(), ExecConstants.OUTPUT_FORMAT_VALIDATOR.getDefault().getValue()), new Object[0]);
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = %s", ExecConstants.JSON_EXTENDED_TYPES.getOptionName(), ExecConstants.JSON_EXTENDED_TYPES.getDefault().getValue()), new Object[0]);
            throw throwable;
        }
        TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = '%s'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName(), ExecConstants.OUTPUT_FORMAT_VALIDATOR.getDefault().getValue()), new Object[0]);
        TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = %s", ExecConstants.JSON_EXTENDED_TYPES.getOptionName(), ExecConstants.JSON_EXTENDED_TYPES.getDefault().getValue()), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMongoExtendedTypes() throws Exception {
        String originalFile = "${WORKING_PATH}/src/test/resources/vector/complex/mongo_extended.json".replaceAll(Pattern.quote("${WORKING_PATH}"), Matcher.quoteReplacement(TestTools.getWorkingPath()));
        try {
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = 'json'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName()), new Object[0]);
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = true", ExecConstants.JSON_EXTENDED_TYPES.getOptionName()), new Object[0]);
            int actualRecordCount = TestExtendedTypes.testSql(String.format("select * from dfs.`%s`", originalFile));
            Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", 1, actualRecordCount), (long)1L, (long)actualRecordCount);
        }
        catch (Throwable throwable) {
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = '%s'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName(), ExecConstants.OUTPUT_FORMAT_VALIDATOR.getDefault().getValue()), new Object[0]);
            TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = %s", ExecConstants.JSON_EXTENDED_TYPES.getOptionName(), ExecConstants.JSON_EXTENDED_TYPES.getDefault().getValue()), new Object[0]);
            throw throwable;
        }
        TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = '%s'", ExecConstants.OUTPUT_FORMAT_VALIDATOR.getOptionName(), ExecConstants.OUTPUT_FORMAT_VALIDATOR.getDefault().getValue()), new Object[0]);
        TestExtendedTypes.testNoResult(String.format("ALTER SESSION SET `%s` = %s", ExecConstants.JSON_EXTENDED_TYPES.getOptionName(), ExecConstants.JSON_EXTENDED_TYPES.getDefault().getValue()), new Object[0]);
    }
}

