/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.hadoop.io.Text;

public class VarCharHolderReaderImpl
extends AbstractFieldReader {
    private VarCharHolder holder;

    public VarCharHolderReaderImpl(VarCharHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return VarCharHolder.TYPE;
    }

    public boolean isSet() {
        return true;
    }

    @Override
    public Text readText() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }
}

