/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class Var16CharWriterImpl
extends AbstractFieldWriter {
    private final Var16CharVector.Mutator mutator;
    final Var16CharVector vector;

    public Var16CharWriterImpl(Var16CharVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(Var16CharHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVar16CharHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVar16Char(int start, int end, DrillBuf buffer) {
        this.mutator.setSafe(this.idx(), start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

