/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedVarCharVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedVarCharWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.hadoop.io.Text;

public class RepeatedVarCharReaderImpl
extends AbstractFieldReader {
    private final RepeatedVarCharVector vector;

    public RepeatedVarCharReaderImpl(RepeatedVarCharVector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(VarCharWriter writer) {
        RepeatedVarCharWriterImpl impl = (RepeatedVarCharWriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedVarCharWriterImpl impl = (RepeatedVarCharWriterImpl)((Object)writer.list(name).varChar());
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public int size() {
        return this.vector.getAccessor().getInnerValueCountAt(this.idx());
    }

    @Override
    public void read(int arrayIndex, VarCharHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public void read(int arrayIndex, NullableVarCharHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public Text readText(int arrayIndex) {
        return this.vector.getAccessor().getSingleObject(this.idx(), arrayIndex);
    }

    @Override
    public List<Object> readObject() {
        return (List)this.vector.getAccessor().getObject(this.idx());
    }
}

