/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedVarBinaryVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedVarBinaryWriterImpl
extends AbstractFieldWriter {
    private final RepeatedVarBinaryVector.Mutator mutator;
    final RepeatedVarBinaryVector vector;

    public RepeatedVarBinaryWriterImpl(RepeatedVarBinaryVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(VarBinaryHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVarBinaryHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarBinary(int start, int end, DrillBuf buffer) {
        this.mutator.addSafe(this.idx(), start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void setPosition(int idx) {
        super.setPosition(idx);
        this.mutator.startNewValue(idx);
    }
}

