/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedUInt4Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedUInt4WriterImpl
extends AbstractFieldWriter {
    private final RepeatedUInt4Vector.Mutator mutator;
    final RepeatedUInt4Vector vector;

    public RepeatedUInt4WriterImpl(RepeatedUInt4Vector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(UInt4Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableUInt4Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeUInt4(int value) {
        this.mutator.addSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void setPosition(int idx) {
        super.setPosition(idx);
        this.mutator.startNewValue(idx);
    }
}

