/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.RepeatedTimeStampHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.joda.time.DateTime;

public class RepeatedTimeStampHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeStampHolder holder = new NullableTimeStampHolder();
    private int index = -1;
    private RepeatedTimeStampHolder repeatedHolder;

    public RepeatedTimeStampHolderReaderImpl(RepeatedTimeStampHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return RepeatedTimeStampHolder.TYPE;
    }

    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public DateTime readDateTime(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        DateTime value = this.readDateTime();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public DateTime readDateTime() {
        if (!this.isSet()) {
            return null;
        }
        DateTime value = new DateTime(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        ArrayList valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        DateTime value = new DateTime(this.holder.value);
        return value;
    }
}

