/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28DenseVector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38DenseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableIntervalDayVector;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.NullableIntervalYearVector;
import org.apache.drill.exec.vector.NullableSmallIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableTinyIntVector;
import org.apache.drill.exec.vector.NullableUInt1Vector;
import org.apache.drill.exec.vector.NullableUInt2Vector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableUInt8Vector;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import org.apache.drill.exec.vector.complex.impl.NullableBigIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableBitWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDateWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal18WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal28DenseWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal28SparseWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal38DenseWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal38SparseWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal9WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalDayWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalYearWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableSmallIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeStampWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTinyIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt1WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt2WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVar16CharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarBinaryWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarCharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.SingleListWriter;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal18Writer;
import org.apache.drill.exec.vector.complex.writer.Decimal28DenseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal28SparseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38DenseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38SparseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal9Writer;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalYearWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;
import org.apache.drill.exec.vector.complex.writer.TinyIntWriter;
import org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import org.apache.drill.exec.vector.complex.writer.UInt2Writer;
import org.apache.drill.exec.vector.complex.writer.UInt4Writer;
import org.apache.drill.exec.vector.complex.writer.UInt8Writer;
import org.apache.drill.exec.vector.complex.writer.Var16CharWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;

public class RepeatedMapWriter
extends AbstractFieldWriter {
    protected final RepeatedMapVector container;
    private final Map<String, FieldWriter> fields = Maps.newHashMap();
    private int currentChildIndex = 0;
    private static final TypeProtos.MajorType TINYINT_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.TINYINT);
    private static final TypeProtos.MajorType UINT1_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.UINT1);
    private static final TypeProtos.MajorType UINT2_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.UINT2);
    private static final TypeProtos.MajorType SMALLINT_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.SMALLINT);
    private static final TypeProtos.MajorType INT_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT);
    private static final TypeProtos.MajorType UINT4_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.UINT4);
    private static final TypeProtos.MajorType FLOAT4_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4);
    private static final TypeProtos.MajorType TIME_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.TIME);
    private static final TypeProtos.MajorType INTERVALYEAR_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INTERVALYEAR);
    private static final TypeProtos.MajorType BIGINT_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT);
    private static final TypeProtos.MajorType UINT8_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.UINT8);
    private static final TypeProtos.MajorType FLOAT8_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8);
    private static final TypeProtos.MajorType DATE_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.DATE);
    private static final TypeProtos.MajorType TIMESTAMP_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.TIMESTAMP);
    private static final TypeProtos.MajorType INTERVALDAY_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INTERVALDAY);
    private static final TypeProtos.MajorType INTERVAL_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INTERVAL);
    private static final TypeProtos.MajorType VARBINARY_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARBINARY);
    private static final TypeProtos.MajorType VARCHAR_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR);
    private static final TypeProtos.MajorType VAR16CHAR_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VAR16CHAR);
    private static final TypeProtos.MajorType BIT_TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIT);

    public RepeatedMapWriter(RepeatedMapVector container, FieldWriter parent) {
        super(parent);
        this.container = container;
    }

    public int getValueCapacity() {
        return this.container.getValueCapacity();
    }

    public MaterializedField getField() {
        return this.container.getField();
    }

    @Override
    public BaseWriter.MapWriter map(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            int vectorCount = this.container.size();
            MapVector vector = (MapVector)this.container.addOrGet(name, MapVector.TYPE, MapVector.class);
            writer = new SingleMapWriter(vector, this);
            if (vectorCount != this.container.size()) {
                writer.allocate();
            }
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    public void close() throws Exception {
        this.clear();
        this.container.close();
    }

    public void allocate() {
        this.container.allocateNew();
        for (FieldWriter w : this.fields.values()) {
            w.allocate();
        }
    }

    public void clear() {
        this.container.clear();
        for (FieldWriter w : this.fields.values()) {
            w.clear();
        }
    }

    @Override
    public BaseWriter.ListWriter list(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            writer = new SingleListWriter(name, (AbstractContainerVector)this.container, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public void start() {
        RepeatedMapHolder h = new RepeatedMapHolder();
        RepeatedMapVector map = this.container;
        RepeatedMapVector.Mutator mutator = map.getMutator();
        if (this.container.getValueCapacity() <= this.idx()) {
            mutator.setValueCount(this.idx() + 1);
        }
        map.getAccessor().get(this.idx(), h);
        if (h.start >= h.end) {
            this.container.getMutator().startNewValue(this.idx());
        }
        this.currentChildIndex = this.container.getMutator().add(this.idx());
        for (FieldWriter w : this.fields.values()) {
            w.setPosition(this.currentChildIndex);
        }
    }

    @Override
    public void end() {
    }

    @Override
    public TinyIntWriter tinyInt(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableTinyIntVector vector = (NullableTinyIntVector)this.container.addOrGet(name, TINYINT_TYPE, NullableTinyIntVector.class);
            vector.allocateNewSafe();
            writer = new NullableTinyIntWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public UInt1Writer uInt1(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableUInt1Vector vector = (NullableUInt1Vector)this.container.addOrGet(name, UINT1_TYPE, NullableUInt1Vector.class);
            vector.allocateNewSafe();
            writer = new NullableUInt1WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public UInt2Writer uInt2(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableUInt2Vector vector = (NullableUInt2Vector)this.container.addOrGet(name, UINT2_TYPE, NullableUInt2Vector.class);
            vector.allocateNewSafe();
            writer = new NullableUInt2WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public SmallIntWriter smallInt(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableSmallIntVector vector = (NullableSmallIntVector)this.container.addOrGet(name, SMALLINT_TYPE, NullableSmallIntVector.class);
            vector.allocateNewSafe();
            writer = new NullableSmallIntWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public IntWriter integer(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableIntVector vector = (NullableIntVector)this.container.addOrGet(name, INT_TYPE, NullableIntVector.class);
            vector.allocateNewSafe();
            writer = new NullableIntWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public UInt4Writer uInt4(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableUInt4Vector vector = (NullableUInt4Vector)this.container.addOrGet(name, UINT4_TYPE, NullableUInt4Vector.class);
            vector.allocateNewSafe();
            writer = new NullableUInt4WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Float4Writer float4(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableFloat4Vector vector = (NullableFloat4Vector)this.container.addOrGet(name, FLOAT4_TYPE, NullableFloat4Vector.class);
            vector.allocateNewSafe();
            writer = new NullableFloat4WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public TimeWriter time(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableTimeVector vector = (NullableTimeVector)this.container.addOrGet(name, TIME_TYPE, NullableTimeVector.class);
            vector.allocateNewSafe();
            writer = new NullableTimeWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public IntervalYearWriter intervalYear(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableIntervalYearVector vector = (NullableIntervalYearVector)this.container.addOrGet(name, INTERVALYEAR_TYPE, NullableIntervalYearVector.class);
            vector.allocateNewSafe();
            writer = new NullableIntervalYearWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal9Writer decimal9(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal9Writer decimal9(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL9_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL9, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal9Vector vector = (NullableDecimal9Vector)this.container.addOrGet(name, DECIMAL9_TYPE, NullableDecimal9Vector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal9WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public BigIntWriter bigInt(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableBigIntVector vector = (NullableBigIntVector)this.container.addOrGet(name, BIGINT_TYPE, NullableBigIntVector.class);
            vector.allocateNewSafe();
            writer = new NullableBigIntWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public UInt8Writer uInt8(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableUInt8Vector vector = (NullableUInt8Vector)this.container.addOrGet(name, UINT8_TYPE, NullableUInt8Vector.class);
            vector.allocateNewSafe();
            writer = new NullableUInt8WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Float8Writer float8(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableFloat8Vector vector = (NullableFloat8Vector)this.container.addOrGet(name, FLOAT8_TYPE, NullableFloat8Vector.class);
            vector.allocateNewSafe();
            writer = new NullableFloat8WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public DateWriter date(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDateVector vector = (NullableDateVector)this.container.addOrGet(name, DATE_TYPE, NullableDateVector.class);
            vector.allocateNewSafe();
            writer = new NullableDateWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public TimeStampWriter timeStamp(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableTimeStampVector vector = (NullableTimeStampVector)this.container.addOrGet(name, TIMESTAMP_TYPE, NullableTimeStampVector.class);
            vector.allocateNewSafe();
            writer = new NullableTimeStampWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal18Writer decimal18(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal18Writer decimal18(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL18_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL18, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal18Vector vector = (NullableDecimal18Vector)this.container.addOrGet(name, DECIMAL18_TYPE, NullableDecimal18Vector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal18WriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public IntervalDayWriter intervalDay(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableIntervalDayVector vector = (NullableIntervalDayVector)this.container.addOrGet(name, INTERVALDAY_TYPE, NullableIntervalDayVector.class);
            vector.allocateNewSafe();
            writer = new NullableIntervalDayWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public IntervalWriter interval(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableIntervalVector vector = (NullableIntervalVector)this.container.addOrGet(name, INTERVAL_TYPE, NullableIntervalVector.class);
            vector.allocateNewSafe();
            writer = new NullableIntervalWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal28DenseWriter decimal28Dense(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal28DenseWriter decimal28Dense(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL28DENSE_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL28DENSE, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal28DenseVector vector = (NullableDecimal28DenseVector)this.container.addOrGet(name, DECIMAL28DENSE_TYPE, NullableDecimal28DenseVector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal28DenseWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal38DenseWriter decimal38Dense(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal38DenseWriter decimal38Dense(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL38DENSE_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL38DENSE, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal38DenseVector vector = (NullableDecimal38DenseVector)this.container.addOrGet(name, DECIMAL38DENSE_TYPE, NullableDecimal38DenseVector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal38DenseWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal38SparseWriter decimal38Sparse(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal38SparseWriter decimal38Sparse(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL38SPARSE_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL38SPARSE, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal38SparseVector vector = (NullableDecimal38SparseVector)this.container.addOrGet(name, DECIMAL38SPARSE_TYPE, NullableDecimal38SparseVector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal38SparseWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Decimal28SparseWriter decimal28Sparse(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        assert (writer != null);
        return writer;
    }

    @Override
    public Decimal28SparseWriter decimal28Sparse(String name, int scale, int precision) {
        TypeProtos.MajorType DECIMAL28SPARSE_TYPE = Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL28SPARSE, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL, (int)scale, (int)precision);
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableDecimal28SparseVector vector = (NullableDecimal28SparseVector)this.container.addOrGet(name, DECIMAL28SPARSE_TYPE, NullableDecimal28SparseVector.class);
            vector.allocateNewSafe();
            writer = new NullableDecimal28SparseWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public VarBinaryWriter varBinary(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableVarBinaryVector vector = (NullableVarBinaryVector)this.container.addOrGet(name, VARBINARY_TYPE, NullableVarBinaryVector.class);
            vector.allocateNewSafe();
            writer = new NullableVarBinaryWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public VarCharWriter varChar(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableVarCharVector vector = (NullableVarCharVector)this.container.addOrGet(name, VARCHAR_TYPE, NullableVarCharVector.class);
            vector.allocateNewSafe();
            writer = new NullableVarCharWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public Var16CharWriter var16Char(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableVar16CharVector vector = (NullableVar16CharVector)this.container.addOrGet(name, VAR16CHAR_TYPE, NullableVar16CharVector.class);
            vector.allocateNewSafe();
            writer = new NullableVar16CharWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }

    @Override
    public BitWriter bit(String name) {
        FieldWriter writer = this.fields.get(name.toLowerCase());
        if (writer == null) {
            NullableBitVector vector = (NullableBitVector)this.container.addOrGet(name, BIT_TYPE, NullableBitVector.class);
            vector.allocateNewSafe();
            writer = new NullableBitWriterImpl(vector, this);
            writer.setPosition(this.currentChildIndex);
            this.fields.put(name.toLowerCase(), writer);
        }
        return writer;
    }
}

