/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.joda.time.Period;

public class RepeatedIntervalHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalHolder holder = new NullableIntervalHolder();
    private int index = -1;
    private RepeatedIntervalHolder repeatedHolder;

    public RepeatedIntervalHolderReaderImpl(RepeatedIntervalHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return RepeatedIntervalHolder.TYPE;
    }

    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Period readPeriod(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Period value = this.readPeriod();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Period readPeriod() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        ArrayList valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }
}

