/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedIntervalDayVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedIntervalDayWriterImpl
extends AbstractFieldWriter {
    private final RepeatedIntervalDayVector.Mutator mutator;
    final RepeatedIntervalDayVector vector;

    public RepeatedIntervalDayWriterImpl(RepeatedIntervalDayVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(IntervalDayHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableIntervalDayHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeIntervalDay(int days, int milliseconds) {
        this.mutator.addSafe(this.idx(), days, milliseconds);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void setPosition(int idx) {
        super.setPosition(idx);
        this.mutator.startNewValue(idx);
    }
}

