/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal28SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class RepeatedDecimal28SparseHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal28SparseHolder holder = new NullableDecimal28SparseHolder();
    private int index = -1;
    private RepeatedDecimal28SparseHolder repeatedHolder;

    public RepeatedDecimal28SparseHolderReaderImpl(RepeatedDecimal28SparseHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return RepeatedDecimal28SparseHolder.TYPE;
    }

    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        BigDecimal value = this.readBigDecimal();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)5, (int)this.holder.scale);
    }

    @Override
    public Object readObject() {
        ArrayList valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)5, (int)this.holder.scale);
    }
}

