/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.RepeatedBitHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class RepeatedBitHolderReaderImpl
extends AbstractFieldReader {
    private NullableBitHolder holder = new NullableBitHolder();
    private int index = -1;
    private RepeatedBitHolder repeatedHolder;

    public RepeatedBitHolderReaderImpl(RepeatedBitHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return RepeatedBitHolder.TYPE;
    }

    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Boolean readBoolean(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Boolean value = this.readBoolean();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Boolean readBoolean() {
        if (!this.isSet()) {
            return null;
        }
        return new Boolean(this.holder.value != 0);
    }

    @Override
    public Object readObject() {
        ArrayList valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return new Boolean(this.holder.value != 0);
    }
}

